/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.Activator;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis.AbstractDpdkEthdevThroughputDataProvider;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis.AbstractPortQueueBuilder;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis.DpdkEthdevThroughputAnalysisModule;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class DpdkEthdevThroughputPpsDataProvider
extends AbstractDpdkEthdevThroughputDataProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.dpdk.ethdev.throughput.pps.dataprovider";
    private static final String PROVIDER_TITLE = "Dpdk Ethernet Device Throughput - PPS";
    private static final String BINARY_SPEED_UNIT = "/s";
    private static final TmfXYAxisDescription Y_AXIS_DESCRIPTION = new TmfXYAxisDescription(Objects.requireNonNull(Messages.DpdkEthdev_ThroughputPpsDataProvider_YAxis), "/s", DataType.NUMBER);

    public static @Nullable DpdkEthdevThroughputPpsDataProvider create(ITmfTrace trace) {
        DpdkEthdevThroughputAnalysisModule module = (DpdkEthdevThroughputAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, DpdkEthdevThroughputAnalysisModule.class, (String)"org.eclipse.tracecompass.incubator.dpdk.ethdev.throughput.analysis");
        return module != null ? new DpdkEthdevThroughputPpsDataProvider(trace, module) : null;
    }

    private DpdkEthdevThroughputPpsDataProvider(ITmfTrace trace, DpdkEthdevThroughputAnalysisModule module) {
        super(trace, module);
    }

    protected String getTitle() {
        return PROVIDER_TITLE;
    }

    public String getId() {
        return ID;
    }

    protected @Nullable Collection<IYModel> getYSeriesModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return null;
        }
        long[] xValues = filter.getTimesRequested();
        List<PortQueueBuilder> builders = this.initBuilders(ss, filter);
        if (builders.isEmpty()) {
            return Collections.emptyList();
        }
        long currentEnd = ss.getCurrentEndTime();
        long prevTime = filter.getStart();
        if (prevTime >= ss.getStartTime() && prevTime <= currentEnd) {
            List states = ss.queryFullState(prevTime);
            for (PortQueueBuilder builder2 : builders) {
                builder2.setPrevCount(DpdkEthdevThroughputPpsDataProvider.extractCount(ss, states, builder2.fQueueQuark, builder2.fIsProfileMetric));
            }
        }
        int i = 1;
        while (i < xValues.length) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            long time = xValues[i];
            if (time > currentEnd) break;
            if (time >= ss.getStartTime()) {
                List states = ss.queryFullState(time);
                for (PortQueueBuilder builder3 : builders) {
                    double count = DpdkEthdevThroughputPpsDataProvider.extractCount(ss, states, builder3.fQueueQuark, builder3.fIsProfileMetric);
                    builder3.updateValue(i, count, time - prevTime);
                }
            }
            prevTime = time;
            ++i;
        }
        return ImmutableList.copyOf((Collection)builders.stream().map(builder -> builder.build(Y_AXIS_DESCRIPTION)).collect(Collectors.toList()));
    }

    private static double extractCount(ITmfStateSystem ss, List<ITmfStateInterval> states, int queueQuark, boolean isProfileMetric) {
        try {
            int metricQuark;
            int n = metricQuark = isProfileMetric ? ss.optQuarkRelative(queueQuark, new String[]{"pkt_cnt_p"}) : ss.optQuarkRelative(queueQuark, new String[]{"pkt_cnt"});
            if (metricQuark != -2) {
                Object stateValue = states.get(metricQuark).getValue();
                return stateValue instanceof Number ? ((Number)stateValue).doubleValue() : 0.0;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Activator.getInstance().logError(e.getMessage());
        }
        return Double.NaN;
    }

    protected List<PortQueueBuilder> initBuilders(ITmfStateSystem ss, SelectionTimeQueryFilter filter) {
        int length = filter.getTimesRequested().length;
        ArrayList<PortQueueBuilder> builders = new ArrayList<PortQueueBuilder>();
        for (Map.Entry entry : this.getSelectedEntries(filter).entrySet()) {
            int parentQuark;
            long id = Objects.requireNonNull((Long)entry.getKey());
            int quark = Objects.requireNonNull((Integer)entry.getValue());
            if (quark == -1 || ss.getParentAttributeQuark(quark) == -1 || (parentQuark = ss.getParentAttributeQuark(quark)) == -2 || !"rx_qs".equals(ss.getAttributeName(parentQuark)) && !"tx_qs".equals(ss.getAttributeName(parentQuark))) continue;
            int portQuark = ss.getParentAttributeQuark(parentQuark);
            String name = this.getTrace().getName() + "/" + ss.getAttributeName(portQuark) + "/" + ss.getAttributeName(parentQuark) + "/" + ss.getAttributeName(quark);
            boolean isProfileMetric = ss.getAttributeName(quark).equals("pkt_cnt_p");
            builders.add(new PortQueueBuilder(id, quark, isProfileMetric, name, length));
        }
        return builders;
    }

    protected class PortQueueBuilder
    extends AbstractPortQueueBuilder {
        private final boolean fIsProfileMetric;

        protected PortQueueBuilder(long id, int queueQuark, boolean isProfileMetric, String name, int length) {
            super(id, queueQuark, name, length);
            this.fIsProfileMetric = isProfileMetric;
        }

        @Override
        protected void updateValue(int pos, double newCount, long deltaT) {
            this.fValues[pos] = (newCount - this.fPrevCount) / (1.0E-9 * (double)deltaT);
            this.fPrevCount = newCount;
        }
    }
}

