/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow.RosMessageFlowAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow.RosMessageFlowDataProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow.IRosMessageFlowModel;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosMessageFlowDataProviderFactory
implements IDataProviderFactory {
    private final Map<ITmfTrace, RosMessageFlowAnalysis> fMap = new HashMap<ITmfTrace, RosMessageFlowAnalysis>();

    public RosMessageFlowDataProviderFactory() {
        TmfSignalManager.register((Object)this);
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(@NonNull ITmfTrace trace) {
        RosMessageFlowAnalysis module = this.fMap.remove(trace);
        if (module == null) {
            return null;
        }
        IRosMessageFlowModel model = module.getModel();
        if (model == null) {
            return null;
        }
        return new RosMessageFlowDataProvider(trace, model);
    }

    @TmfSignalHandler
    public synchronized void analysisStarted(TmfStartAnalysisSignal startAnalysisSignal) {
        IAnalysisModule module = startAnalysisSignal.getAnalysisModule();
        if (module instanceof RosMessageFlowAnalysis) {
            RosMessageFlowAnalysis analysis = (RosMessageFlowAnalysis)module;
            this.fMap.put(analysis.getTrace(), analysis);
        }
    }

    @TmfSignalHandler
    public synchronized void traceClosed(TmfTraceClosedSignal traceClosedSignal) {
        this.fMap.remove(traceClosedSignal.getTrace());
    }
}

