/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.IRosModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.IRosModelProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class RosModelUtils {
    public static <M extends IRosModel, P extends IRosModelProvider<M> & IAnalysisModule> @Nullable M getModelFromAnalysis(@NonNull ITmfTrace trace, @NonNull Class<@NonNull P> moduleClass, @NonNull String id) {
        @Nullable IRosModelProvider modelAnalysis = (IRosModelProvider)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, moduleClass, (String)id);
        if (modelAnalysis == null) {
            throw new IllegalStateException("There should be an analysis for this class");
        }
        ((IAnalysisModule)modelAnalysis).schedule();
        if (!((IAnalysisModule)modelAnalysis).waitForCompletion()) {
            throw new IllegalStateException("Problem waiting for the analysis");
        }
        @Nullable M model = modelAnalysis.getModel();
        if (model == null) {
            Activator.getInstance().logError("Model is null");
        }
        return model;
    }

    public static <A extends TmfStateSystemAnalysisModule> @Nullable ITmfStateSystem getStateSystemFromAnalysis(@NonNull ITmfTrace trace, @NonNull Class<@NonNull A> moduleClass, @NonNull String id) {
        @Nullable TmfStateSystemAnalysisModule analysis = (TmfStateSystemAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, moduleClass, (String)id);
        if (analysis == null) {
            throw new IllegalStateException("There should be an analysis for this class");
        }
        analysis.schedule();
        if (!analysis.waitForCompletion()) {
            throw new IllegalStateException("Problem waiting for the analysis");
        }
        @Nullable ITmfStateSystem ss = analysis.getStateSystem();
        if (ss == null) {
            Activator.getInstance().logError("State system is null");
        }
        return ss;
    }
}

