/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.internal.core.ByteUtils;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryArchive;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryExecutable;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryObject;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryShared;
import org.eclipse.core.runtime.IPath;

public class ElfParser
extends AbstractCExtension
implements IBinaryParser {
    @Override
    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        return this.getBinary(null, path);
    }

    @Override
    public IBinaryParser.IBinaryFile getBinary(byte[] hints, IPath path) throws IOException {
        IBinaryParser.IBinaryFile binary;
        block15: {
            if (path == null) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
            }
            binary = null;
            if (hints != null && AR.isARHeader(hints)) {
                binary = this.createBinaryArchive(path);
            } else {
                try {
                    Elf.Attribute attribute = ElfParser.getAttribute(hints, path);
                    if (attribute != null) {
                        switch (attribute.getType()) {
                            case 1: {
                                binary = this.createBinaryExecutable(path);
                                break;
                            }
                            case 2: {
                                binary = ElfParser.hasInterpProgramHeader(hints, path) ? this.createBinaryExecutable(path) : this.createBinaryShared(path);
                                break;
                            }
                            case 3: {
                                binary = this.createBinaryObject(path);
                                break;
                            }
                            case 4: {
                                binary = this.createBinaryCore(path);
                            }
                        }
                        if (binary instanceof ElfBinaryObject) {
                            ((ElfBinaryObject)binary).setElfAttributes(attribute);
                        }
                    }
                }
                catch (IOException e) {
                    if (hints != null) break block15;
                    try {
                        binary = this.createBinaryArchive(path);
                    }
                    catch (IOException e2) {
                        CCorePlugin.log(e);
                        throw e2;
                    }
                }
            }
        }
        return binary;
    }

    @Override
    public String getFormat() {
        return "ELF";
    }

    @Override
    public boolean isBinary(byte[] array, IPath path) {
        return Elf.isElfHeader(array) || AR.isARHeader(array);
    }

    @Override
    public int getHintBufferSize() {
        return 128;
    }

    protected IBinaryParser.IBinaryArchive createBinaryArchive(IPath path) throws IOException {
        return new ElfBinaryArchive(this, path);
    }

    protected IBinaryParser.IBinaryObject createBinaryObject(IPath path) throws IOException {
        return new ElfBinaryObject((IBinaryParser)this, path, 1);
    }

    protected IBinaryParser.IBinaryExecutable createBinaryExecutable(IPath path) throws IOException {
        return new ElfBinaryExecutable(this, path);
    }

    protected IBinaryParser.IBinaryShared createBinaryShared(IPath path) throws IOException {
        return new ElfBinaryShared(this, path);
    }

    protected IBinaryParser.IBinaryObject createBinaryCore(IPath path) throws IOException {
        return new ElfBinaryObject((IBinaryParser)this, path, 16);
    }

    private static Elf.Attribute getAttribute(byte[] hints, IPath path) throws IOException {
        if (Elf.isElfHeader(hints)) {
            try {
                return Elf.getAttributes(hints);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return Elf.getAttributes(path.toOSString());
    }

    private static boolean hasInterpProgramHeader(byte[] hints, IPath path) throws IOException {
        if (Elf.isElfHeader(hints)) {
            int e_phentsizeOffset = 0;
            int e_phnumOffset = 0;
            int e_ehsizeOffset = 0;
            switch (hints[4]) {
                case 1: {
                    e_ehsizeOffset = 40;
                    e_phentsizeOffset = 42;
                    e_phnumOffset = 44;
                    break;
                }
                case 2: {
                    e_ehsizeOffset = 52;
                    e_phentsizeOffset = 54;
                    e_phnumOffset = 56;
                    break;
                }
                default: {
                    CCorePlugin.log(2, "Unknown ELF header class in file: " + path.toOSString());
                    return false;
                }
            }
            if (e_phnumOffset + 2 < hints.length) {
                boolean isle = hints[5] == 1;
                short e_phentsize = ByteUtils.makeShort(hints, e_phentsizeOffset, isle);
                short e_phnum = ByteUtils.makeShort(hints, e_phnumOffset, isle);
                int e_ehsize = ByteUtils.makeShort(hints, e_ehsizeOffset, isle);
                int lastProgramHeaderOffset = e_ehsize + (e_phnum - 1) * e_phentsize;
                int i = e_ehsize;
                while (i < Math.min(lastProgramHeaderOffset, hints.length) + 4) {
                    if (ByteUtils.makeInt(hints, i, isle) == 3L) {
                        return true;
                    }
                    i += e_phentsize;
                }
                if (lastProgramHeaderOffset + 4 < hints.length) {
                    return false;
                }
            }
        }
        try {
            return Arrays.stream(ElfParser.getPHdrs(path)).anyMatch(phdr -> phdr.p_type == 3L);
        }
        catch (Elf.ElfClassNoneException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    private static Elf.PHdr[] getPHdrs(IPath path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Elf elf = new Elf(path.toOSString());){
            return elf.getPHdrs();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

