/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.markers;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.internal.tmf.core.markers.SubMarker;

public class Marker {
    private final String fName;
    private final String fColor;
    private final List<SubMarker> fSubMarkers;

    protected Marker(String name, String color) {
        this.fName = name;
        this.fColor = color;
        this.fSubMarkers = new ArrayList<SubMarker>();
    }

    public String getName() {
        return this.fName;
    }

    public String getColor() {
        return this.fColor;
    }

    public List<SubMarker> getSubMarkers() {
        return this.fSubMarkers;
    }

    public void addSubMarker(SubMarker subMarker) {
        this.fSubMarkers.add(subMarker);
    }

    public static class PeriodicMarker
    extends Marker {
        private final String fLabel;
        private final String fId;
        private final String fReferenceId;
        private final double fPeriod;
        private final String fUnit;
        private final Range<Long> fRange;
        private final long fOffset;
        private final RangeSet<Long> fIndexRange;

        public PeriodicMarker(String name, String label, String id, String referenceId, String color, double period, String unit, Range<Long> range, long offset, RangeSet<Long> indexRange) {
            super(name, color);
            this.fLabel = label;
            this.fId = id;
            this.fReferenceId = referenceId;
            this.fPeriod = period;
            this.fUnit = unit;
            this.fRange = range;
            this.fOffset = offset;
            this.fIndexRange = indexRange;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getId() {
            return this.fId;
        }

        public String getReferenceId() {
            return this.fReferenceId;
        }

        public double getPeriod() {
            return this.fPeriod;
        }

        public String getUnit() {
            return this.fUnit;
        }

        public Range<Long> getRange() {
            return this.fRange;
        }

        public long getOffset() {
            return this.fOffset;
        }

        public RangeSet<Long> getIndexRange() {
            return this.fIndexRange;
        }
    }
}

