/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalConditional;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTConditionalExpression
extends ASTNode
implements IASTConditionalExpression,
ICPPASTExpression,
IASTAmbiguityParent {
    private ICPPASTExpression fCondition;
    private ICPPASTExpression fPositive;
    private ICPPASTExpression fNegative;
    private ICPPEvaluation fEval;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTConditionalExpression() {
    }

    public CPPASTConditionalExpression(IASTExpression condition, IASTExpression postive, IASTExpression negative) {
        this.setLogicalConditionExpression(condition);
        this.setPositiveResultExpression(postive);
        this.setNegativeResultExpression(negative);
    }

    @Override
    public CPPASTConditionalExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTConditionalExpression copy(IASTNode.CopyStyle style) {
        CPPASTConditionalExpression copy = new CPPASTConditionalExpression();
        copy.setLogicalConditionExpression(this.fCondition == null ? null : this.fCondition.copy(style));
        copy.setPositiveResultExpression(this.fPositive == null ? null : this.fPositive.copy(style));
        copy.setNegativeResultExpression(this.fNegative == null ? null : this.fNegative.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getLogicalConditionExpression() {
        return this.fCondition;
    }

    @Override
    public void setLogicalConditionExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fCondition = (ICPPASTExpression)expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(LOGICAL_CONDITION);
        }
    }

    @Override
    public IASTExpression getPositiveResultExpression() {
        return this.fPositive;
    }

    @Override
    public void setPositiveResultExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fPositive = (ICPPASTExpression)expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(POSITIVE_RESULT);
        }
    }

    @Override
    public IASTExpression getNegativeResultExpression() {
        return this.fNegative;
    }

    @Override
    public void setNegativeResultExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fNegative = (ICPPASTExpression)expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEGATIVE_RESULT);
        }
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fCondition != null && !this.fCondition.accept(action)) {
            return false;
        }
        if (this.fPositive != null && !this.fPositive.accept(action)) {
            return false;
        }
        if (this.fNegative != null && !this.fNegative.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTConditionalExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fCondition) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fCondition = (ICPPASTExpression)other;
        }
        if (child == this.fPositive) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fPositive = (ICPPASTExpression)other;
        }
        if (child == this.fNegative) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fNegative = (ICPPASTExpression)other;
        }
    }

    private boolean isThrowExpression(IASTExpression expr) {
        while (expr instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpr = (IASTUnaryExpression)expr;
            int op = unaryExpr.getOperator();
            if (op == 12) {
                return true;
            }
            if (op == 11) {
                expr = unaryExpr.getOperand();
                continue;
            }
            return false;
        }
        return false;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEval == null) {
            if (this.fCondition == null || this.fNegative == null) {
                this.fEval = EvalFixed.INCOMPLETE;
            } else {
                ICPPEvaluation condEval = this.fCondition.getEvaluation();
                ICPPEvaluation posEval = this.fPositive == null ? null : this.fPositive.getEvaluation();
                ICPPEvaluation negEval = this.fNegative.getEvaluation();
                this.fEval = new EvalConditional(condEval, posEval, negEval, this.isThrowExpression(this.fPositive), this.isThrowExpression(this.fNegative), this);
            }
        }
        return this.fEval;
    }

    @Override
    public IType getExpressionType() {
        return CPPEvaluation.getType(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return CPPEvaluation.getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }
}

