/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statesystem;

import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.collect.BufferedBlockingQueue;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfStateProvider
implements ITmfStateProvider {
    private static final Logger LOGGER = TraceCompassLog.getLogger(AbstractTmfStateProvider.class);
    private static final int DEFAULT_EVENTS_QUEUE_SIZE = 127;
    private static final int DEFAULT_EVENTS_CHUNK_SIZE = 127;
    private final ITmfTrace fTrace;
    private final BufferedBlockingQueue<ITmfEvent> fEventsQueue;
    private final Thread fEventHandlerThread;
    private boolean fStateSystemAssigned;
    private @Nullable ITmfStateSystemBuilder fSS = null;
    private @Nullable Throwable fFailureCause = null;
    private volatile long fSafeTime;
    private Runnable fPropagateExceptions = () -> {};
    private final Queue<FutureEvent> fFutureEvents = new PriorityQueue<FutureEvent>(Comparator.comparingLong(FutureEvent::getTime));
    private static final EndEvent END_EVENT = new EndEvent();
    private static final EmptyQueueEvent EMPTY_QUEUE_EVENT = new EmptyQueueEvent();

    public AbstractTmfStateProvider(ITmfTrace trace, String id) {
        this(trace, id, 127, 127);
    }

    @VisibleForTesting
    protected AbstractTmfStateProvider(ITmfTrace trace, String id, int queueSize, int chunkSize) {
        if (queueSize <= 0 || chunkSize <= 0) {
            throw new IllegalArgumentException("Cannot have negative sized buffer" + AbstractTmfStateProvider.formatError("queueSize", queueSize) + AbstractTmfStateProvider.formatError("chunkSize", chunkSize));
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractTmfStateProvider:creating object", new Object[0]).setCategory(id).build();){
            this.fTrace = trace;
            this.fEventsQueue = new BufferedBlockingQueue(queueSize, chunkSize);
            this.fStateSystemAssigned = false;
            this.fSafeTime = trace.getStartTime().toNanos() - 1L;
            this.fEventHandlerThread = new Thread(() -> SafeRunner.run((ISafeRunnable)new EventProcessor(log)), String.valueOf(id) + " Event Handler");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String formatError(String name, int value) {
        return value <= 0 ? " " + name + " = " + value : "";
    }

    protected @Nullable ITmfStateSystemBuilder getStateSystemBuilder() {
        return this.fSS;
    }

    @Override
    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public long getStartTime() {
        return this.fTrace.getStartTime().toNanos();
    }

    @Override
    public long getLatestSafeTime() {
        return this.fSafeTime;
    }

    @Override
    public void assignTargetStateSystem(ITmfStateSystemBuilder ssb) {
        this.fSS = ssb;
        this.fStateSystemAssigned = true;
        this.fEventHandlerThread.start();
    }

    @Override
    public @Nullable ITmfStateSystem getAssignedStateSystem() {
        return this.fSS;
    }

    @Override
    public void dispose() {
        try {
            this.fEventsQueue.put((Object)END_EVENT);
            this.fEventsQueue.flushInputBuffer();
            this.fEventHandlerThread.join();
        }
        catch (InterruptedException e) {
            Activator.logError("Error disposing state provider", e);
        }
        this.fStateSystemAssigned = false;
        this.fSS = null;
    }

    @Override
    public void processEvent(ITmfEvent event) {
        if (!this.fStateSystemAssigned) {
            throw new IllegalStateException("Cannot process event without a target state system. ID: " + this.getClass().getSimpleName());
        }
        this.fPropagateExceptions.run();
        ITmfEvent curEvent = event;
        this.fEventsQueue.put((Object)curEvent);
    }

    @Override
    public void fail(Throwable cause) {
        this.fFailureCause = cause;
    }

    @Override
    public @Nullable Throwable getFailureCause() {
        return this.fFailureCause;
    }

    public void waitForEmptyQueue() {
        try {
            this.fEventsQueue.put((Object)EMPTY_QUEUE_EVENT);
            this.fEventsQueue.flushInputBuffer();
            while (!this.fEventsQueue.isEmpty()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void addFutureEvent(long time, @Nullable Object futureValue, int attribute) {
        this.addFutureEvent(time, futureValue, attribute, ITmfStateProvider.FutureEventType.MODIFICATION);
    }

    @Override
    public void addFutureEvent(long time, @Nullable Object futureValue, int attribute, ITmfStateProvider.FutureEventType type) {
        this.fFutureEvents.add(new FutureEvent(time, futureValue, attribute, type));
    }

    protected abstract void eventHandle(ITmfEvent var1);

    private static class EmptyQueueEvent
    extends TmfEvent {
        public EmptyQueueEvent() {
            super(null, -1L, null, null, null);
        }
    }

    private static class EndEvent
    extends TmfEvent {
        public EndEvent() {
            super(null, -1L, null, null, null);
        }
    }

    private class EventProcessor
    implements ISafeRunnable {
        private final TraceCompassLogUtils.FlowScopeLog fLog;
        private @Nullable ITmfEvent currentEvent;
        private boolean fDone = false;

        public EventProcessor(TraceCompassLogUtils.FlowScopeLog log) {
            this.fLog = log;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 7[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void applyFutureEvent(FutureEvent futureEvent, ITmfStateSystemBuilder stateSystemBuilder) {
            switch (futureEvent.fType) {
                case MODIFICATION: {
                    stateSystemBuilder.modifyAttribute(futureEvent.fTime, futureEvent.fValue, futureEvent.fQuark);
                    break;
                }
                case PUSH: {
                    stateSystemBuilder.pushAttribute(futureEvent.fTime, futureEvent.fValue, futureEvent.fQuark);
                    break;
                }
                case POP: {
                    stateSystemBuilder.popAttributeObject(futureEvent.fTime, futureEvent.fQuark);
                    break;
                }
            }
        }

        private void closeStateSystem() {
            long endTime;
            ITmfEvent event = this.currentEvent;
            long l = endTime = event == null ? Long.MIN_VALUE : event.getTimestamp().toNanos();
            if (AbstractTmfStateProvider.this.fSS != null) {
                AbstractTmfStateProvider.this.fSS.closeHistory(endTime);
            }
        }

        public void handleException(@Nullable Throwable exception) {
            RuntimeException rException = exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException("Error in threaded state history backend", exception);
            AbstractTmfStateProvider.this.fail(rException);
            AbstractTmfStateProvider.this.fPropagateExceptions = () -> {
                throw rException;
            };
            if (this.fDone) {
                return;
            }
            ITmfEvent event = (ITmfEvent)AbstractTmfStateProvider.this.fEventsQueue.take();
            while (event != END_EVENT) {
                event = event == EMPTY_QUEUE_EVENT ? (ITmfEvent)AbstractTmfStateProvider.this.fEventsQueue.take() : (ITmfEvent)AbstractTmfStateProvider.this.fEventsQueue.take();
            }
            this.closeStateSystem();
        }
    }

    private static final class FutureEvent {
        private final long fTime;
        private final @Nullable Object fValue;
        private final int fQuark;
        private final ITmfStateProvider.FutureEventType fType;

        public FutureEvent(long time, @Nullable Object futureValue, int quark, ITmfStateProvider.FutureEventType type) {
            this.fTime = time;
            this.fValue = futureValue;
            this.fQuark = quark;
            this.fType = type;
        }

        public long getTime() {
            return this.fTime;
        }
    }
}

