/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model.config;

import org.eclipse.tracecompass.tmf.core.config.ITmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigParamDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class TmfConfigParamDescriptorTest {
    private static final String PATH = "path";
    private static final String DESC = "descriptor";
    private static final String DATA_TYPE = "NUMBER";
    private static final String EXPECTED_TO_STRING = "TmfConfigParamDescriptor[fKeyName=path, fDataType=NUMBER, fIsRequired=true, fDescription=descriptor]";
    private static final String EXPECTED_DEFAULT_DATA_TYPE = "STRING";

    @Test
    public void testBuilder() {
        TmfConfigParamDescriptor.Builder builder = new TmfConfigParamDescriptor.Builder().setKeyName(PATH).setDescription(DESC).setDataType(DATA_TYPE).setIsRequired(false);
        ITmfConfigParamDescriptor config = builder.build();
        Assert.assertEquals((Object)PATH, (Object)config.getKeyName());
        Assert.assertEquals((Object)DESC, (Object)config.getDescription());
        Assert.assertEquals((Object)DATA_TYPE, (Object)config.getDataType());
        Assert.assertFalse((boolean)config.isRequired());
    }

    @Test
    public void testBuilderMissingParams() {
        TmfConfigParamDescriptor.Builder builder = new TmfConfigParamDescriptor.Builder().setDescription(DESC).setDataType(DATA_TYPE).setIsRequired(false);
        try {
            builder.build();
            Assert.fail((String)"No exception created");
        }
        catch (IllegalStateException illegalStateException) {}
        builder = new TmfConfigParamDescriptor.Builder().setKeyName(PATH);
        ITmfConfigParamDescriptor config = builder.build();
        Assert.assertEquals((Object)PATH, (Object)config.getKeyName());
        Assert.assertTrue((boolean)config.getDescription().isEmpty());
        Assert.assertEquals((Object)EXPECTED_DEFAULT_DATA_TYPE, (Object)config.getDataType());
        Assert.assertTrue((boolean)config.isRequired());
    }

    @Test
    public void testEquality() {
        TmfConfigParamDescriptor.Builder builder = new TmfConfigParamDescriptor.Builder().setKeyName(PATH).setDescription(DESC).setDataType(DATA_TYPE).setIsRequired(false);
        ITmfConfigParamDescriptor baseConfiguration = builder.build();
        ITmfConfigParamDescriptor testConfig = builder.build();
        Assert.assertEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setKeyName("Other path");
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setKeyName(PATH);
        builder.setDescription("Other desc");
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setDescription(DESC);
        builder.setDataType(EXPECTED_DEFAULT_DATA_TYPE);
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setDataType(DATA_TYPE);
        builder.setIsRequired(true);
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
    }

    @Test
    public void testToString() {
        TmfConfigParamDescriptor.Builder builder = new TmfConfigParamDescriptor.Builder().setKeyName(PATH).setDescription(DESC).setDataType(DATA_TYPE);
        Assert.assertEquals((Object)EXPECTED_TO_STRING, (Object)builder.build().toString());
    }

    @Test
    public void testHashCode() {
        TmfConfigParamDescriptor.Builder builder = new TmfConfigParamDescriptor.Builder().setKeyName(PATH).setDescription(DESC).setDataType(DATA_TYPE);
        ITmfConfigParamDescriptor config1 = builder.build();
        builder = new TmfConfigParamDescriptor.Builder().setKeyName("path1").setDescription("descriptor1").setDataType("NUMBER1").setIsRequired(false);
        ITmfConfigParamDescriptor config2 = builder.build();
        Assert.assertEquals((long)config1.hashCode(), (long)config1.hashCode());
        Assert.assertEquals((long)config2.hashCode(), (long)config2.hashCode());
        Assert.assertNotEquals((long)config1.hashCode(), (long)config2.hashCode());
    }
}

