/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.tests.trace;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.tracecompass.btf.core.event.BtfEvent;
import org.eclipse.tracecompass.btf.core.tests.utils.BtfTestTrace;
import org.eclipse.tracecompass.btf.core.trace.BtfColumnNames;
import org.eclipse.tracecompass.btf.core.trace.BtfTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BtfTraceTest {
    private static final long START_TIME = 1392809960000000000L;
    private static final String[] ECXPECT_CONTENT_EVENT_0 = new String[]{String.valueOf(1392809960000000000L), "SEM_DataElement1", "0", "SEM_DataElement1", "0", "Semaphore", "ready", "0"};
    private static final int EVENT_RANK_10 = 10;
    private static final String[] ECXPECT_CONTENT_EVENT_10 = new String[]{String.valueOf(1392809960000000000L), "TASK_10MS_DL2", "0", "SCHED_Tasks_C1", "-1", "Scheduler", "processactivate", "some note"};
    private static final int EVENT_RANK_COMMENT_TEST = 98;
    private static final long EVENT_COMMENT_TIME = 1392809960000956750L;
    private static final String[] ECXPECT_CONTENT_COMMENT_EVENT = new String[]{String.valueOf(1392809960000956750L), "Core_2", "0", "TASK_5MS", "0", "Task", "terminate", ""};
    private BtfTrace fixture;

    @Before
    public void setup() {
        this.fixture = BtfTestTrace.BTF_TEST.getTrace();
        Assert.assertNotNull((Object)this.fixture);
    }

    @After
    public void cleanup() {
        this.fixture.dispose();
    }

    @Test
    public void testValidate() {
        TraceValidationStatus status = (TraceValidationStatus)this.fixture.validate(null, this.fixture.getPath());
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isOK());
        Assert.assertEquals((long)100L, (long)status.getConfidence());
    }

    @Test
    public void testSeek1stEvent() {
        ITmfContext ctx = this.fixture.seekEvent(0L);
        Assert.assertNotNull((Object)ctx);
        Assert.assertEquals((long)0L, (long)ctx.getRank());
        Assert.assertEquals((Object)499L, (Object)ctx.getLocation().getLocationInfo());
        BtfTraceTest.validateCommentEvent(ECXPECT_CONTENT_EVENT_0, this.fixture.getNext(ctx));
    }

    @Test
    public void testRead1stEvent() {
        ITmfContext ctx = this.fixture.seekEvent(0L);
        ITmfEvent event = this.fixture.getNext(ctx);
        Assert.assertNotNull((Object)event);
        BtfTraceTest.validateCommentEvent(ECXPECT_CONTENT_EVENT_0, event);
    }

    @Test
    public void testRead10thEvent1() {
        ITmfContext ctx = this.fixture.seekEvent(10L);
        ITmfEvent event = this.fixture.getNext(ctx);
        Assert.assertNotNull((Object)event);
        BtfTraceTest.validateCommentEvent(ECXPECT_CONTENT_EVENT_10, event);
    }

    @Test
    public void testRead10thEvent2() {
        ITmfContext ctx = this.fixture.seekEvent(0L);
        ITmfEvent event = this.fixture.getNext(ctx);
        int i = 0;
        while (i < 10) {
            event = this.fixture.getNext(ctx);
            ++i;
        }
        Assert.assertNotNull((Object)event);
        BtfTraceTest.validateCommentEvent(ECXPECT_CONTENT_EVENT_10, event);
    }

    @Test
    public void testReadCommentLineEvent1() {
        ITmfContext ctx = this.fixture.seekEvent(98L);
        ITmfEvent event = this.fixture.getNext(ctx);
        Assert.assertNotNull((Object)event);
        BtfTraceTest.validateCommentEvent(ECXPECT_CONTENT_COMMENT_EVENT, event);
    }

    @Test
    public void testReadCommentLineEvent2() {
        ITmfContext ctx = this.fixture.seekEvent(0L);
        ITmfEvent event = this.fixture.getNext(ctx);
        int i = 0;
        while (i < 98) {
            event = this.fixture.getNext(ctx);
            ++i;
        }
        Assert.assertNotNull((Object)event);
        BtfTraceTest.validateCommentEvent(ECXPECT_CONTENT_COMMENT_EVENT, event);
    }

    @Test
    public void testReadProperties() {
        Map data = this.fixture.getProperties();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((Object)"ns", data.get("#timeScale"));
        Assert.assertEquals((Object)"2.1.0", data.get("#version"));
    }

    @Test
    public void testTwoContexts() {
        ITmfContext ctx0 = this.fixture.seekEvent(0L);
        ITmfContext ctx1 = this.fixture.seekEvent(10L);
        ITmfEvent event = null;
        int i = 0;
        while (i < 11) {
            event = this.fixture.getNext(ctx0);
            ++i;
        }
        ITmfEvent event1 = this.fixture.getNext(ctx1);
        Assert.assertNotNull((Object)event);
        Assert.assertNotNull((Object)event1);
        Assert.assertEquals((Object)event, (Object)event1);
    }

    private static void validateCommentEvent(String[] expected, ITmfEvent event) {
        Assert.assertTrue((boolean)(event instanceof BtfEvent));
        BtfEvent btfEvent = (BtfEvent)event;
        ArrayList<String> actual = new ArrayList<String>();
        actual.add(String.valueOf(event.getTimestamp().getValue()));
        actual.add(btfEvent.getSource());
        actual.add(event.getContent().getField(new String[]{BtfColumnNames.SOURCE_INSTANCE.toString()}).getValue().toString());
        actual.add(btfEvent.getTarget());
        actual.add(event.getContent().getField(new String[]{BtfColumnNames.TARGET_INSTANCE.toString()}).getValue().toString());
        actual.add(event.getType().getName());
        actual.add(event.getContent().getField(new String[]{BtfColumnNames.EVENT.toString()}).getValue().toString());
        String notes = (String)event.getContent().getFieldValue(String.class, new String[]{BtfColumnNames.NOTES.toString()});
        actual.add(notes == null ? "" : notes);
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)String.valueOf(i), (Object)expected[i], actual.get(i));
            ++i;
        }
    }
}

