/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class MultiEditorInput
implements IEditorInput {
    IEditorInput[] input;
    String[] editors;

    public MultiEditorInput(String[] editorIDs, IEditorInput[] innerEditors) {
        Assert.isNotNull((Object)editorIDs);
        Assert.isNotNull((Object)innerEditors);
        this.editors = editorIDs;
        this.input = innerEditors;
    }

    public IEditorInput[] getInput() {
        return this.input;
    }

    public String[] getEditors() {
        return this.editors;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getName() {
        StringBuilder name = new StringBuilder();
        int i = 0;
        while (i < this.input.length - 1) {
            name.append(this.input[i].getName()).append("/");
            ++i;
        }
        name.append(this.input[this.input.length - 1].getName());
        return name.toString();
    }

    @Override
    public IPersistableElement getPersistable() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return this.getName();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiEditorInput)) {
            return false;
        }
        MultiEditorInput other = (MultiEditorInput)obj;
        return Arrays.equals(this.editors, other.editors) && Arrays.equals(this.input, other.input);
    }

    public int hashCode() {
        int hash = 0;
        Object[] objectArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            String editor = objectArray[n2];
            hash = hash * 37 + editor.hashCode();
            ++n2;
        }
        objectArray = this.input;
        n = this.input.length;
        n2 = 0;
        while (n2 < n) {
            Object editorInput = objectArray[n2];
            hash = hash * 37 + editorInput.hashCode();
            ++n2;
        }
        return hash;
    }
}

