/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.genericeditor.ContentAssistProcessorRegistry;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.eclipse.wst.sse.ui.internal.Logger;

public class GenericCompletionProposalComputer
implements ICompletionProposalComputer,
IExecutableExtension {
    List<IContentAssistProcessor> fContentAssistProcessors = null;
    private String fLastErrorMessage;
    private String fDefaultFileName = "filename.html";

    @Override
    public void sessionEnded() {
        this.fContentAssistProcessors = null;
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        ISourceViewer viewer = null;
        this.fLastErrorMessage = null;
        if (context.getViewer() instanceof ISourceViewer) {
            viewer = (ISourceViewer)context.getViewer();
        }
        if (this.fContentAssistProcessors == null && viewer != null) {
            IPath path;
            String filename = this.fDefaultFileName;
            ITextFileBuffer fileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(viewer.getDocument());
            if (fileBuffer != null && (path = fileBuffer.getLocation()) != null) {
                filename = path.lastSegment();
            }
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            ContentAssistProcessorRegistry contentAssistProcessorRegistry = GenericEditorPlugin.getDefault().getContentAssistProcessorRegistry();
            HashSet<IContentType> types = new HashSet<IContentType>();
            types.addAll(Arrays.asList(contentTypeManager.findContentTypesFor(filename)));
            IContentType contentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
            types.add(contentType);
            try {
                this.fContentAssistProcessors = contentAssistProcessorRegistry.getContentAssistProcessors(viewer, null, types);
            }
            catch (NoClassDefFoundError e) {
                Logger.logException(e);
            }
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            ICompletionProposal[] computed = processor.computeCompletionProposals(context.getViewer(), context.getInvocationOffset());
            proposals.addAll(Arrays.asList(computed));
            String errorMessage = processor.getErrorMessage();
            if (errorMessage == null) continue;
            this.fLastErrorMessage = this.fLastErrorMessage == null ? processor.getErrorMessage() : this.fLastErrorMessage.concat("\n").concat(errorMessage);
        }
        return proposals;
    }

    @Override
    public List<IContextInformation> computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        ISourceViewer viewer = null;
        this.fLastErrorMessage = null;
        if (context.getViewer() instanceof ISourceViewer) {
            viewer = (ISourceViewer)context.getViewer();
        }
        if (this.fContentAssistProcessors == null && viewer != null) {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            ContentAssistProcessorRegistry contentAssistProcessorRegistry = GenericEditorPlugin.getDefault().getContentAssistProcessorRegistry();
            HashSet<IContentType> types = new HashSet<IContentType>();
            types.addAll(Arrays.asList(contentTypeManager.findContentTypesFor(this.fDefaultFileName)));
            IContentType contentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
            types.add(contentType);
            this.fContentAssistProcessors = contentAssistProcessorRegistry.getContentAssistProcessors(viewer, null, types);
        }
        ArrayList<IContextInformation> infos = new ArrayList<IContextInformation>();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            IContextInformation[] computed = processor.computeContextInformation(context.getViewer(), context.getInvocationOffset());
            infos.addAll(Arrays.asList(computed));
            String errorMessage = processor.getErrorMessage();
            if (errorMessage == null) continue;
            this.fLastErrorMessage = this.fLastErrorMessage == null ? processor.getErrorMessage() : this.fLastErrorMessage.concat("\n").concat(errorMessage);
        }
        return infos;
    }

    @Override
    public String getErrorMessage() {
        return this.fLastErrorMessage;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.fDefaultFileName = data.toString();
        }
    }
}

