/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.stubs;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackStateProvider;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CallStackProviderStub
extends CallStackStateProvider {
    public static final String ENTRY = "entry";
    public static final String EXIT = "exit";
    public static final String FIELD_NAME = "op";
    private static final ITmfStateValue NO_FUNC_EXIT = TmfStateValue.newValueString((String)"unknown");

    public CallStackProviderStub(@NonNull ITmfTrace trace) {
        super(trace);
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull CallStackStateProvider getNewInstance() {
        return new CallStackProviderStub(this.getTrace());
    }

    protected boolean considerEvent(@NonNull ITmfEvent event) {
        return true;
    }

    protected @Nullable ITmfStateValue functionEntry(@NonNull ITmfEvent event) {
        ITmfEventField field;
        String name = event.getName();
        if (ENTRY.equals(name) && (field = event.getContent().getField(new String[]{FIELD_NAME})) != null) {
            return TmfStateValue.newValueString((String)((String)field.getValue()));
        }
        return null;
    }

    protected @Nullable ITmfStateValue functionExit(@NonNull ITmfEvent event) {
        String name = event.getName();
        if (EXIT.equals(name)) {
            ITmfEventField field = event.getContent().getField(new String[]{FIELD_NAME});
            if (field != null) {
                return TmfStateValue.newValueString((String)((String)field.getValue()));
            }
            return NO_FUNC_EXIT;
        }
        return null;
    }

    protected int getProcessId(@NonNull ITmfEvent event) {
        return CallStackProviderStub.getProcessIdFromEvent(event);
    }

    public static int getProcessIdFromEvent(@NonNull ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{"pid"});
        if (field != null) {
            return Integer.parseInt((String)field.getValue());
        }
        return -1;
    }

    protected long getThreadId(@NonNull ITmfEvent event) {
        return CallStackProviderStub.getThreadIdFromEvent(event);
    }

    public static long getThreadIdFromEvent(@NonNull ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{"tid"});
        if (field != null) {
            return Integer.parseInt((String)field.getValue());
        }
        return -1L;
    }
}

