/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteDoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.ByteDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableByteDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.ByteDoublePair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedByteDoubleProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ByteDoubleHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

/**
 * ImmutableByteDoubleHashMap is the non-modifiable equivalent of {@link ByteDoubleHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableByteDoubleHashMap implements ImmutableByteDoubleMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableByteDoubleMap delegate;

    ImmutableByteDoubleHashMap(ByteDoubleMap delegate)
    {
        this.delegate = new ByteDoubleHashMap(delegate);
    }

    public double get(byte key)
    {
        return this.delegate.get(key);
    }

    public double getIfAbsent(byte key, double ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public double getOrThrow(byte key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(byte key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(double value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ByteProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ByteDoubleProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyByteIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<ByteDoublePair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableByteDoubleMap select(ByteDoublePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteDoubleMap reject(ByteDoublePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableByteDoubleMap toImmutable()
    {
        return this;
    }

    public DoubleIterator doubleIterator()
    {
        return new UnmodifiableDoubleIterator(this.delegate.doubleIterator());
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(DoubleProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(DoublePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum()
    {
        return this.delegate.sum();
    }

    public double max()
    {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double min()
    {
        return this.delegate.min();
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public double[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public double[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(double value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(double... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableDoubleList toList()
    {
        return this.delegate.toList();
    }

    public MutableDoubleSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableByteDoubleMap newWithKeyValue(byte key, double value)
    {
        MutableByteDoubleMap map = new ByteDoubleHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableByteDoubleMap newWithoutKey(byte key)
    {
        MutableByteDoubleMap map = new ByteDoubleHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableByteDoubleMap newWithoutAllKeys(ByteIterable keys)
    {
        MutableByteDoubleMap map = new ByteDoubleHashMap(this.size());
        map.putAll(this);
        ByteIterator iterator = keys.byteIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableByteSet keySet()
    {
        return UnmodifiableByteSet.of(this.delegate.keySet());
    }

    public MutableDoubleCollection values()
    {
        return UnmodifiableDoubleCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableByteDoubleMapSerializationProxy(this);
    }

    protected static class ImmutableByteDoubleMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private ByteDoubleMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableByteDoubleMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableByteDoubleMapSerializationProxy(ByteDoubleMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedByteDoubleProcedure()
                {
                    @Override
                    public void safeValue(byte key, double value) throws IOException
                    {
                        out.writeByte(key);
                        out.writeDouble(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableByteDoubleMap deserializedMap = new ByteDoubleHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readByte(), in.readDouble());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
