/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharFloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.CharFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharFloatMap;
import org.eclipse.collections.api.map.primitive.MutableCharFloatMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.CharFloatPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedCharFloatProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.map.mutable.primitive.CharFloatHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;

/**
 * ImmutableCharFloatHashMap is the non-modifiable equivalent of {@link CharFloatHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableCharFloatHashMap implements ImmutableCharFloatMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableCharFloatMap delegate;

    ImmutableCharFloatHashMap(CharFloatMap delegate)
    {
        this.delegate = new CharFloatHashMap(delegate);
    }

    public float get(char key)
    {
        return this.delegate.get(key);
    }

    public float getIfAbsent(char key, float ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(char key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(char key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(float value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(CharFloatProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<CharFloatPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableCharFloatMap select(CharFloatPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharFloatMap reject(CharFloatPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableCharFloatMap toImmutable()
    {
        return this;
    }

    public FloatIterator floatIterator()
    {
        return new UnmodifiableFloatIterator(this.delegate.floatIterator());
    }

    public void forEach(FloatProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(FloatProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(FloatPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum()
    {
        return this.delegate.sum();
    }

    public float max()
    {
        return this.delegate.max();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public float min()
    {
        return this.delegate.min();
    }

    public float minIfEmpty(float defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public float[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableFloatList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public float[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(float value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(float... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(FloatIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableFloatList toList()
    {
        return this.delegate.toList();
    }

    public MutableFloatSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableFloatBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyFloatIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableCharFloatMap newWithKeyValue(char key, float value)
    {
        MutableCharFloatMap map = new CharFloatHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableCharFloatMap newWithoutKey(char key)
    {
        MutableCharFloatMap map = new CharFloatHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableCharFloatMap newWithoutAllKeys(CharIterable keys)
    {
        MutableCharFloatMap map = new CharFloatHashMap(this.size());
        map.putAll(this);
        CharIterator iterator = keys.charIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableCharSet keySet()
    {
        return UnmodifiableCharSet.of(this.delegate.keySet());
    }

    public MutableFloatCollection values()
    {
        return UnmodifiableFloatCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableCharFloatMapSerializationProxy(this);
    }

    protected static class ImmutableCharFloatMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private CharFloatMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableCharFloatMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableCharFloatMapSerializationProxy(CharFloatMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedCharFloatProcedure()
                {
                    @Override
                    public void safeValue(char key, float value) throws IOException
                    {
                        out.writeChar(key);
                        out.writeFloat(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableCharFloatMap deserializedMap = new CharFloatHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readChar(), in.readFloat());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
