/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.IntLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntLongMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.IntLongPair;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyIntIterate;

/**
 * ImmutableIntLongEmptyMap is an optimization for {@link ImmutableIntLongMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableIntLongEmptyMap implements ImmutableIntLongMap, Serializable
{
    static final ImmutableIntLongMap INSTANCE = new ImmutableIntLongEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public long get(int key)
    {
        return EMPTY_VALUE;
    }

    public long getIfAbsent(int key, long ifAbsent)
    {
        return ifAbsent;
    }

    public long getOrThrow(int key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key)
    {
        return false;
    }

    public boolean containsValue(long value)
    {
        return false;
    }

    public void forEachValue(LongProcedure procedure)
    {
    }

    public void forEachKey(IntProcedure procedure)
    {
    }

    public void forEachKeyValue(IntLongProcedure procedure)
    {
    }

    public LazyIntIterable keysView()
    {
        return LazyIntIterate.empty();
    }

    public RichIterable<IntLongPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableIntLongMap select(IntLongPredicate predicate)
    {
        return this;
    }

    public ImmutableIntLongMap reject(IntLongPredicate predicate)
    {
        return this;
    }

    public ImmutableIntLongMap toImmutable()
    {
        return this;
    }

    public LongIterator longIterator()
    {
        return ImmutableEmptyLongIterator.INSTANCE;
    }

    public void forEach(LongProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
    }

    public int count(LongPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public long min()
    {
        throw new NoSuchElementException();
    }

    public long max()
    {
        throw new NoSuchElementException();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return defaultValue;
    }

    public long minIfEmpty(long defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public long[] toSortedArray()
    {
        return new long[0];
    }

    public MutableLongList toSortedList()
    {
        return new LongArrayList();
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return true;
    }

    public ImmutableLongCollection select(LongPredicate predicate)
    {
        return LongLists.immutable.with();
    }

    public ImmutableLongCollection reject(LongPredicate predicate)
    {
        return LongLists.immutable.with();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public long[] toArray()
    {
        return new long[0];
    }

    public boolean contains(long value)
    {
        return false;
    }

    public boolean containsAll(long... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(LongIterable source)
    {
        return source.isEmpty();
    }

    public MutableLongList toList()
    {
        return new LongArrayList();
    }

    public MutableLongSet toSet()
    {
        return new LongHashSet();
    }

    public MutableLongBag toBag()
    {
        return new LongHashBag();
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public ImmutableIntLongMap newWithKeyValue(int key, long value)
    {
        return new ImmutableIntLongSingletonMap(key, value);
    }

    public ImmutableIntLongMap newWithoutKey(int key)
    {
        return this;
    }

    public ImmutableIntLongMap newWithoutAllKeys(IntIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(new IntHashSet());
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(new LongArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof IntLongMap))
        {
            return false;
        }
        IntLongMap map = (IntLongMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
