/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.IntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntIntProcedure;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableIntHashBag
implements ImmutableIntBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntBag delegate;

    private ImmutableIntHashBag(int[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = IntHashBag.newBagWith(newElements);
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use IntBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableIntHashBag newBagWith(int ... elements) {
        return new ImmutableIntHashBag(elements);
    }

    public ImmutableIntBag newWith(int element) {
        return IntHashBag.newBag((IntBag)this.delegate).with(element).toImmutable();
    }

    public ImmutableIntBag newWithout(int element) {
        IntHashBag hashBag = IntHashBag.newBag((IntBag)this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    public ImmutableIntBag newWithAll(IntIterable elements) {
        IntHashBag bag = IntHashBag.newBag((IntBag)this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    public ImmutableIntBag newWithoutAll(IntIterable elements) {
        IntHashBag bag = IntHashBag.newBag((IntBag)this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(int ... elements) {
        return this.delegate.containsAll(elements);
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public ImmutableIntBag select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntBag reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public MutableIntList toList() {
        return this.delegate.toList();
    }

    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    public int occurrencesOf(int item) {
        return this.delegate.occurrencesOf(item);
    }

    public void forEachWithOccurrences(IntIntProcedure intIntProcedure) {
        this.delegate.forEachWithOccurrences(intIntProcedure);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public int min() {
        return this.delegate.min();
    }

    public int max() {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    public ImmutableIntBag toImmutable() {
        return this;
    }

    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    public int[] toArray() {
        return this.delegate.toArray();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)this.delegate.intIterator());
    }

    private Object writeReplace() {
        return new ImmutableIntBagSerializationProxy((IntBag)this);
    }

    protected static class ImmutableIntBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntBag bag;

        public ImmutableIntBagSerializationProxy() {
        }

        protected ImmutableIntBagSerializationProxy(IntBag bag) {
            this.bag = bag;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences((IntIntProcedure)new CheckedIntIntProcedure(){

                    public void safeValue(int item, int count) throws IOException {
                        out.writeInt(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntHashBag deserializedBag = new IntHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readInt(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

