/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.euclidean;

import java.io.Serializable;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.projective.Straight3D;
import org.eclipse.gef4.geometry.projective.Vector3D;
import org.eclipse.gef4.geometry.utils.PrecisionUtils;

public class Straight
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public Vector position;
    public Vector direction;

    public static double getSignedDistanceCCW(Point p, Point q, Point r) {
        Straight3D line = Straight3D.through(new Vector3D(p), new Vector3D(q));
        if (line == null) {
            return 0.0;
        }
        return -line.getSignedDistanceCW(new Vector3D(r));
    }

    public Straight(Line line) {
        this(line.getP1(), line.getP2());
    }

    public Straight(Point point1, Point point2) {
        this(new Vector(point1), new Vector(point1, point2));
    }

    public Straight(Vector position, Vector direction) {
        this.position = position.clone();
        this.direction = direction.clone();
    }

    public Straight clone() {
        return this.getCopy();
    }

    public boolean contains(Vector vector) {
        return PrecisionUtils.equal(this.getDistance(vector), 0.0);
    }

    public boolean containsWithinSegment(Vector segmentStart, Vector segmentEnd, Vector vector) {
        if (!this.contains(segmentStart) || !this.contains(segmentEnd)) {
            throw new IllegalArgumentException("segment points have to be contained");
        }
        Vector segmentDirection = segmentEnd.getSubtracted(segmentStart);
        if (segmentDirection.isNull()) {
            return segmentStart.equals(vector);
        }
        if (new Straight(segmentStart, segmentDirection).contains(vector)) {
            double s;
            double d = s = segmentDirection.isVertical() ? (vector.y - segmentStart.y) / segmentDirection.y : (vector.x - segmentStart.x) / segmentDirection.x;
            if (PrecisionUtils.smallerEqual(0.0, s) && PrecisionUtils.smallerEqual(s, 1.0)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Straight)) {
            return false;
        }
        Straight otherStraight = (Straight)other;
        return this.contains(otherStraight.position) && this.isParallelTo(otherStraight);
    }

    public Angle getAngle(Straight other) {
        return this.direction.getAngle(other.direction);
    }

    public Angle getAngleCCW(Straight other) {
        Angle angle = this.getAngle(other);
        if (this.direction.getCrossProduct(other.direction) > 0.0) {
            angle = angle.getOppositeSemi();
        }
        return angle;
    }

    public Angle getAngleCW(Straight other) {
        Angle angle0;
        Angle angle = this.getAngleCCW(other);
        if (angle.equals(angle0 = Angle.fromRad(0.0))) {
            return angle0;
        }
        return angle.getOppositeSemi();
    }

    public Straight getCopy() {
        return new Straight(this.position, this.direction);
    }

    public double getDistance(Vector vector) {
        return this.getProjection(vector).getSubtracted(vector).getLength();
    }

    public Vector getIntersection(Straight other) {
        Vector3D l2;
        Vector3D l1 = new Vector3D(this.position.toPoint()).getCrossProduct(new Vector3D(this.position.getAdded(this.direction).toPoint()));
        Point poi = l1.getCrossProduct(l2 = new Vector3D(other.position.toPoint()).getCrossProduct(new Vector3D(other.position.getAdded(other.direction).toPoint()))).toPoint();
        return poi == null ? null : new Vector(poi);
    }

    public double getParameterAt(Vector vp) {
        if (!this.contains(vp)) {
            throw new IllegalArgumentException("The given position Vector has to be on this Straight: getParameterAt(" + vp + "), this = " + this);
        }
        if (Math.abs(this.direction.x) > Math.abs(this.direction.y)) {
            return (vp.x - this.position.x) / this.direction.x;
        }
        if (this.direction.y != 0.0) {
            return (vp.y - this.position.y) / this.direction.y;
        }
        throw new IllegalStateException("The direction Vector of this Straight may not be (0, 0) for this computation: getParameterAt(" + vp + "), this = " + this);
    }

    public Vector getPositionVectorAt(double parameter) {
        return new Vector(this.position.x + this.direction.x * parameter, this.position.y + this.direction.y * parameter);
    }

    public Vector getProjection(Vector vector) {
        Vector normalized = this.direction.getNormalized();
        return new Straight(this.position, normalized).getIntersection(new Straight(vector, normalized.getOrthogonalComplement()));
    }

    public double getSignedDistanceCCW(Vector vector) {
        return Straight.getSignedDistanceCCW(this.position.toPoint(), this.position.getAdded(this.direction).toPoint(), vector.toPoint());
    }

    public double getSignedDistanceCW(Vector vector) {
        return -this.getSignedDistanceCCW(vector);
    }

    public int hashCode() {
        return 0;
    }

    public boolean intersects(Straight other) {
        return !PrecisionUtils.equal(this.direction.getDotProduct(other.direction.getOrthogonalComplement()), 0.0, 6);
    }

    public boolean intersectsWithinSegment(Vector segmentStart, Vector segmentEnd, Straight other) {
        if (!this.contains(segmentStart) || !this.contains(segmentEnd)) {
            throw new IllegalArgumentException("segment points have to be contained");
        }
        Vector segmentDirection = segmentEnd.getSubtracted(segmentStart);
        if (segmentDirection.isNull()) {
            return other.contains(segmentStart);
        }
        if (this.intersects(other)) {
            Vector intersection = this.getIntersection(other);
            return this.containsWithinSegment(segmentStart, segmentEnd, intersection);
        }
        return false;
    }

    public boolean isParallelTo(Straight other) {
        return this.direction.isParallelTo(other.direction);
    }

    public String toString() {
        return "Straight: " + this.position.toString() + " + s * " + this.direction.toString();
    }
}

