/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.Animation;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.interfaces.ConnectionLayout;
import org.eclipse.gef4.layout.interfaces.ContextListener;
import org.eclipse.gef4.layout.interfaces.EntityLayout;
import org.eclipse.gef4.layout.interfaces.ExpandCollapseManager;
import org.eclipse.gef4.layout.interfaces.GraphStructureListener;
import org.eclipse.gef4.layout.interfaces.LayoutContext;
import org.eclipse.gef4.layout.interfaces.LayoutListener;
import org.eclipse.gef4.layout.interfaces.NodeLayout;
import org.eclipse.gef4.layout.interfaces.PruningListener;
import org.eclipse.gef4.layout.interfaces.SubgraphLayout;
import org.eclipse.gef4.zest.core.widgets.DefaultSubgraph;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphContainer;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.core.widgets.GraphWidget;
import org.eclipse.gef4.zest.core.widgets.IContainer;
import org.eclipse.gef4.zest.core.widgets.InternalNodeLayout;
import org.eclipse.gef4.zest.core.widgets.LayoutFilter;
import org.eclipse.gef4.zest.core.widgets.SubgraphFactory;

class InternalLayoutContext
implements LayoutContext {
    final IContainer container;
    private final List<LayoutFilter> filters = new ArrayList<LayoutFilter>();
    private final List<ContextListener> contextListeners = new ArrayList<ContextListener>();
    private final List<GraphStructureListener> graphStructureListeners = new ArrayList<GraphStructureListener>();
    private final List<LayoutListener> layoutListeners = new ArrayList<LayoutListener>();
    private final List<PruningListener> pruningListeners = new ArrayList<PruningListener>();
    private LayoutAlgorithm dynamicAlgorithm;
    private LayoutAlgorithm staticAlgorithm;
    private ExpandCollapseManager expandCollapseManager;
    private SubgraphFactory subgraphFactory = new DefaultSubgraph.DefaultSubgraphFactory();
    private final HashSet<SubgraphLayout> subgraphs = new HashSet();
    private boolean dynamicLayoutEnabled = false;
    private boolean setExpandedInvocation = false;
    private boolean flushChangesInvocation = false;
    private boolean staticLayoutInvocation = false;

    InternalLayoutContext(GraphWidget graph) {
        this.container = graph;
    }

    InternalLayoutContext(GraphContainer container) {
        this.container = container;
    }

    public void addContextListener(ContextListener listener) {
        this.contextListeners.add(listener);
    }

    public void addGraphStructureListener(GraphStructureListener listener) {
        this.graphStructureListeners.add(listener);
    }

    public void addLayoutListener(LayoutListener listener) {
        this.layoutListeners.add(listener);
    }

    public void addPruningListener(PruningListener listener) {
        this.pruningListeners.add(listener);
    }

    public SubgraphLayout createSubgraph(NodeLayout[] nodes) {
        this.checkChangesAllowed();
        NodeLayout[] internalNodes = new InternalNodeLayout[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            internalNodes[i] = (InternalNodeLayout)nodes[i];
            ++i;
        }
        SubgraphLayout subgraph = this.subgraphFactory.createSubgraph(internalNodes, this);
        this.subgraphs.add(subgraph);
        return subgraph;
    }

    void removeSubgrah(DefaultSubgraph subgraph) {
        this.subgraphs.remove(subgraph);
    }

    public void flushChanges(boolean animationHint) {
        if (!this.container.getGraph().isVisible() && animationHint) {
            return;
        }
        this.flushChangesInvocation = true;
        if (animationHint) {
            Animation.markBegin();
        }
        for (GraphNode graphNode : this.container.getNodes()) {
            graphNode.applyLayoutChanges();
        }
        for (GraphConnection graphConnection : this.container.getConnections()) {
            graphConnection.applyLayoutChanges();
        }
        for (DefaultSubgraph defaultSubgraph : this.subgraphs) {
            defaultSubgraph.applyLayoutChanges();
        }
        if (animationHint) {
            Animation.run((int)500);
        }
        this.flushChangesInvocation = false;
    }

    public Rectangle getBounds() {
        Rectangle result = new Rectangle(this.container.getLayoutBounds());
        result.setWidth(result.getWidth() - 20.0);
        result.setHeight(result.getHeight() - 20.0);
        return result;
    }

    public LayoutAlgorithm getDynamicLayoutAlgorithm() {
        return this.dynamicAlgorithm;
    }

    public ExpandCollapseManager getExpandCollapseManager() {
        return this.expandCollapseManager;
    }

    public NodeLayout[] getNodes() {
        ArrayList<InternalNodeLayout> result = new ArrayList<InternalNodeLayout>();
        for (GraphNode node : this.container.getNodes()) {
            if (this.isLayoutItemFiltered(node)) continue;
            result.add(node.getLayout());
        }
        return result.toArray(new NodeLayout[result.size()]);
    }

    public EntityLayout[] getEntities() {
        HashSet<SubgraphLayout> addedSubgraphs = new HashSet<SubgraphLayout>();
        ArrayList<InternalNodeLayout> result = new ArrayList<InternalNodeLayout>();
        for (GraphNode node : this.container.getNodes()) {
            if (this.isLayoutItemFiltered(node)) continue;
            InternalNodeLayout nodeLayout = node.getLayout();
            if (!nodeLayout.isPruned()) {
                result.add(nodeLayout);
                continue;
            }
            SubgraphLayout subgraph = nodeLayout.getSubgraph();
            if (!subgraph.isGraphEntity() || addedSubgraphs.contains(subgraph)) continue;
            result.add((InternalNodeLayout)subgraph);
            addedSubgraphs.add(subgraph);
        }
        return result.toArray(new EntityLayout[result.size()]);
    }

    public SubgraphLayout[] getSubgraphs() {
        SubgraphLayout[] result = new SubgraphLayout[this.subgraphs.size()];
        int subgraphCount = 0;
        block0: for (SubgraphLayout subgraph : this.subgraphs) {
            NodeLayout[] nodes = subgraph.getNodes();
            int i = 0;
            while (i < nodes.length) {
                if (!this.isLayoutItemFiltered(((InternalNodeLayout)nodes[i]).getNode())) {
                    result[subgraphCount++] = subgraph;
                    continue block0;
                }
                ++i;
            }
        }
        if (subgraphCount == this.subgraphs.size()) {
            return result;
        }
        SubgraphLayout[] result2 = new SubgraphLayout[subgraphCount];
        System.arraycopy(result, 0, result2, 0, subgraphCount);
        return result2;
    }

    public boolean isBoundsExpandable() {
        return false;
    }

    public boolean isDynamicLayoutEnabled() {
        return this.dynamicLayoutEnabled;
    }

    public void setDynamicLayoutEnabled(boolean enabled) {
        if (this.dynamicLayoutEnabled != enabled) {
            this.dynamicLayoutEnabled = enabled;
            this.fireBackgroundEnableChangedEvent();
        }
    }

    public boolean isPruningEnabled() {
        return this.expandCollapseManager != null;
    }

    public void removeContextListener(ContextListener listener) {
        this.contextListeners.remove(listener);
    }

    public void removeGraphStructureListener(GraphStructureListener listener) {
        this.graphStructureListeners.remove(listener);
    }

    public void removeLayoutListener(LayoutListener listener) {
        this.layoutListeners.remove(listener);
    }

    public void removePruningListener(PruningListener listener) {
        this.pruningListeners.remove(listener);
    }

    public void setDynamicLayoutAlgorithm(LayoutAlgorithm algorithm) {
        this.dynamicAlgorithm = algorithm;
        this.dynamicAlgorithm.setLayoutContext((LayoutContext)this);
    }

    public void setExpandCollapseManager(ExpandCollapseManager expandCollapseManager) {
        this.expandCollapseManager = expandCollapseManager;
        expandCollapseManager.initExpansion((LayoutContext)this);
    }

    public ConnectionLayout[] getConnections() {
        List<GraphConnection> connections = this.container.getConnections();
        ConnectionLayout[] result = new ConnectionLayout[connections.size()];
        int i = 0;
        for (GraphConnection connection : connections) {
            if (this.isLayoutItemFiltered(connection)) continue;
            result[i++] = connection.getLayout();
        }
        if (i == result.length) {
            return result;
        }
        ConnectionLayout[] result2 = new ConnectionLayout[i];
        System.arraycopy(result, 0, result2, 0, i);
        return result2;
    }

    public ConnectionLayout[] getConnections(EntityLayout source, EntityLayout target) {
        ArrayList<ConnectionLayout> result = new ArrayList<ConnectionLayout>();
        ArrayList<Object> sourcesList = new ArrayList<Object>();
        if (source instanceof NodeLayout) {
            sourcesList.add(source);
        }
        if (source instanceof SubgraphLayout) {
            sourcesList.addAll(Arrays.asList(((SubgraphLayout)source).getNodes()));
        }
        HashSet<Object> targets = new HashSet<Object>();
        if (target instanceof NodeLayout) {
            targets.add(target);
        }
        if (target instanceof SubgraphLayout) {
            targets.addAll(Arrays.asList(((SubgraphLayout)target).getNodes()));
        }
        for (NodeLayout nodeLayout : sourcesList) {
            ConnectionLayout[] outgoingConnections = nodeLayout.getOutgoingConnections();
            int i = 0;
            while (i < outgoingConnections.length) {
                ConnectionLayout connection = outgoingConnections[i];
                if (connection.getSource() == nodeLayout && targets.contains(connection.getTarget()) || connection.getTarget() == nodeLayout && targets.contains(connection.getSource())) {
                    result.add(connection);
                }
                ++i;
            }
        }
        return result.toArray(new ConnectionLayout[result.size()]);
    }

    void addFilter(LayoutFilter filter) {
        this.filters.add(filter);
    }

    void removeFilter(LayoutFilter filter) {
        this.filters.remove(filter);
    }

    boolean isLayoutItemFiltered(GraphItem item) {
        for (LayoutFilter filter : this.filters) {
            if (!filter.isObjectFiltered(item)) continue;
            return true;
        }
        return false;
    }

    void setExpanded(NodeLayout node, boolean expanded) {
        this.setExpandedInvocation = true;
        if (this.expandCollapseManager != null) {
            this.expandCollapseManager.setExpanded((LayoutContext)this, node, expanded);
        }
        this.setExpandedInvocation = false;
    }

    boolean canExpand(NodeLayout node) {
        return this.expandCollapseManager != null && this.expandCollapseManager.canExpand((LayoutContext)this, node);
    }

    boolean canCollapse(NodeLayout node) {
        return this.expandCollapseManager != null && this.expandCollapseManager.canCollapse((LayoutContext)this, node);
    }

    void setSubgraphFactory(SubgraphFactory factory) {
        this.subgraphFactory = factory;
    }

    SubgraphFactory getSubgraphFactory() {
        return this.subgraphFactory;
    }

    public void applyDynamicLayout(boolean clean) {
        if (this.dynamicLayoutEnabled && this.dynamicAlgorithm != null) {
            if (this != this.dynamicAlgorithm.getLayoutContext()) {
                throw new IllegalStateException("Dynamic algorithm is bound to a different context!");
            }
            this.dynamicAlgorithm.applyLayout(clean);
            this.flushChanges(false);
        }
    }

    void setLayoutAlgorithm(LayoutAlgorithm algorithm) {
        this.staticAlgorithm = algorithm;
        this.staticAlgorithm.setLayoutContext((LayoutContext)this);
    }

    LayoutAlgorithm getLayoutAlgorithm() {
        return this.staticAlgorithm;
    }

    public void applyStaticLayout(boolean clean) {
        if (this.staticAlgorithm != null) {
            if (this != this.staticAlgorithm.getLayoutContext()) {
                throw new IllegalStateException("Static algorithm is bound to a different context!");
            }
            this.staticLayoutInvocation = true;
            this.staticAlgorithm.applyLayout(clean);
            this.staticLayoutInvocation = false;
        }
    }

    public LayoutAlgorithm getStaticLayoutAlgorithm() {
        return this.staticAlgorithm;
    }

    public void setStaticLayoutAlgorithm(LayoutAlgorithm algorithm) {
        this.staticAlgorithm = algorithm;
        this.staticAlgorithm.setLayoutContext((LayoutContext)this);
    }

    void checkChangesAllowed() {
        boolean externalLayoutInvocation;
        boolean bl = externalLayoutInvocation = this.staticLayoutInvocation || this.setExpandedInvocation;
        if (!this.dynamicLayoutEnabled && !externalLayoutInvocation) {
            throw new IllegalStateException("no dynamic layout and no external layout invocation");
        }
    }

    public void fireNodeAddedEvent(NodeLayout node) {
        boolean intercepted = this.flushChangesInvocation;
        GraphStructureListener[] listeners = this.graphStructureListeners.toArray(new GraphStructureListener[this.graphStructureListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].nodeAdded((LayoutContext)this, node);
            ++i;
        }
        if (!intercepted) {
            this.applyDynamicLayout(true);
        }
    }

    public void fireNodeRemovedEvent(NodeLayout node) {
        boolean intercepted = this.flushChangesInvocation;
        GraphStructureListener[] listeners = this.graphStructureListeners.toArray(new GraphStructureListener[this.graphStructureListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].nodeRemoved((LayoutContext)this, node);
            ++i;
        }
        if (!intercepted) {
            this.applyDynamicLayout(true);
        }
    }

    public void fireConnectionAddedEvent(ConnectionLayout connection) {
        InternalLayoutContext targetContext;
        InternalLayoutContext sourceContext = ((InternalNodeLayout)connection.getSource()).getOwnerLayoutContext();
        if (sourceContext != (targetContext = ((InternalNodeLayout)connection.getTarget()).getOwnerLayoutContext())) {
            return;
        }
        if (sourceContext == this) {
            boolean intercepted = this.flushChangesInvocation;
            GraphStructureListener[] listeners = this.graphStructureListeners.toArray(new GraphStructureListener[this.graphStructureListeners.size()]);
            int i = 0;
            while (i < listeners.length && !intercepted) {
                intercepted = listeners[i].connectionAdded((LayoutContext)this, connection);
                ++i;
            }
            if (!intercepted) {
                this.applyDynamicLayout(true);
            }
        } else {
            sourceContext.fireConnectionAddedEvent(connection);
        }
    }

    public void fireConnectionRemovedEvent(ConnectionLayout connection) {
        InternalLayoutContext targetContext;
        InternalLayoutContext sourceContext = ((InternalNodeLayout)connection.getSource()).getOwnerLayoutContext();
        if (sourceContext != (targetContext = ((InternalNodeLayout)connection.getTarget()).getOwnerLayoutContext())) {
            return;
        }
        if (sourceContext == this) {
            boolean intercepted = this.flushChangesInvocation;
            GraphStructureListener[] listeners = this.graphStructureListeners.toArray(new GraphStructureListener[this.graphStructureListeners.size()]);
            int i = 0;
            while (i < listeners.length && !intercepted) {
                intercepted = listeners[i].connectionRemoved((LayoutContext)this, connection);
                ++i;
            }
            if (!intercepted) {
                this.applyDynamicLayout(true);
            }
        } else {
            sourceContext.fireConnectionAddedEvent(connection);
        }
    }

    public void fireBoundsChangedEvent() {
        boolean intercepted = this.flushChangesInvocation;
        ContextListener[] listeners = this.contextListeners.toArray(new ContextListener[this.contextListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].boundsChanged((LayoutContext)this);
            ++i;
        }
        if (!intercepted) {
            this.applyDynamicLayout(true);
        }
    }

    public void fireBackgroundEnableChangedEvent() {
        ContextListener[] listeners = this.contextListeners.toArray(new ContextListener[this.contextListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].backgroundEnableChanged((LayoutContext)this);
            ++i;
        }
    }

    public void fireNodeResizedEvent(NodeLayout nodeLayout) {
        InternalNodeLayout node = (InternalNodeLayout)nodeLayout;
        if (!this.flushChangesInvocation) {
            node.refreshSize();
            node.refreshLocation();
        }
        boolean intercepted = this.flushChangesInvocation;
        LayoutListener[] listeners = this.layoutListeners.toArray(new LayoutListener[this.layoutListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].nodeResized((LayoutContext)this, (NodeLayout)node);
            ++i;
        }
        if (!intercepted) {
            this.applyDynamicLayout(true);
        }
    }

    public void fireSubgraphMovedEvent(SubgraphLayout subgraphLayout) {
        DefaultSubgraph subgraph = (DefaultSubgraph)subgraphLayout;
        if (!this.flushChangesInvocation) {
            subgraph.refreshLocation();
        }
        boolean intercepted = this.flushChangesInvocation;
        LayoutListener[] listeners = this.layoutListeners.toArray(new LayoutListener[this.layoutListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].subgraphMoved((LayoutContext)this, (SubgraphLayout)subgraph);
            ++i;
        }
        if (!intercepted) {
            this.applyDynamicLayout(true);
        }
    }

    public void fireSubgraphResizedEvent(SubgraphLayout subgraphLayout) {
        DefaultSubgraph subgraph = (DefaultSubgraph)subgraphLayout;
        if (!this.flushChangesInvocation) {
            subgraph.refreshSize();
            subgraph.refreshLocation();
        }
        boolean intercepted = this.flushChangesInvocation;
        LayoutListener[] listeners = this.layoutListeners.toArray(new LayoutListener[this.layoutListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].subgraphResized((LayoutContext)this, (SubgraphLayout)subgraph);
            ++i;
        }
        if (!intercepted) {
            this.applyDynamicLayout(true);
        }
    }

    public void fireNodeMovedEvent(NodeLayout nodeLayout) {
        InternalNodeLayout node = (InternalNodeLayout)nodeLayout;
        if (!this.flushChangesInvocation) {
            node.refreshLocation();
        }
        boolean intercepted = this.flushChangesInvocation;
        LayoutListener[] listeners = this.layoutListeners.toArray(new LayoutListener[this.layoutListeners.size()]);
        node.setLocation(node.getNode().getLocation().x, node.getNode().getLocation().y);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].nodeMoved((LayoutContext)this, (NodeLayout)node);
            ++i;
        }
        if (!intercepted) {
            this.applyDynamicLayout(true);
        }
    }

    public void firePruningEnableChangedEvent() {
        ContextListener[] listeners = this.contextListeners.toArray(new ContextListener[this.contextListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].pruningEnablementChanged((LayoutContext)this);
            ++i;
        }
    }
}

