/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.internal.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.dot.DotExport;
import org.eclipse.gef4.dot.DotImport;
import org.eclipse.gef4.dot.internal.dot.DotExtractor;
import org.eclipse.gef4.dot.internal.dot.export.DotFileUtils;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphWidget;
import org.eclipse.gef4.zest.internal.ui.DotDirStore;
import org.eclipse.gef4.zest.internal.ui.ZestUiActivator;
import org.eclipse.gef4.zest.internal.ui.ZestUiMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public final class ZestGraphView
extends ViewPart {
    public static final String ID = "org.eclipse.gef4.graph.dot.ZestView";
    private static final String ADD_EXPORT_QUESTION = ZestUiMessages.ZestGraphView_0;
    private static final String ADD_EXPORT_MESSAGE = String.valueOf(ZestUiMessages.ZestGraphView_1) + ZestUiMessages.ZestGraphView_2 + ZestUiMessages.ZestGraphView_3;
    private static final String LOAD = ZestUiMessages.ZestGraphView_4;
    private static final String RESET = ZestUiMessages.ZestGraphView_5;
    private static final String LAYOUT = ZestUiMessages.ZestGraphView_6;
    private static final String EXPORT = ZestUiMessages.ZestGraphView_7;
    private static final String EXPORT_MODE = ZestUiMessages.ZestGraphView_8;
    private static final String UPDATE_MODE = ZestUiMessages.ZestGraphView_9;
    private static final String LINK_MODE = ZestUiMessages.ZestGraphView_10;
    private static final String RESOURCES_ICONS_OPEN_GIF = "resources/icons/open.gif";
    private static final String RESOURCES_ICONS_EXPORT_GIF = "resources/icons/export.gif";
    private static final String RESOURCES_ICONS_RESET = "resources/icons/ask.gif";
    private static final String RESOURCES_ICONS_LAYOUT = "resources/icons/layout.gif";
    private static final String RESOURCES_ICONS_EXPORT_MODE = "resources/icons/export-mode.gif";
    private static final String RESOURCES_ICONS_UPDATE_MODE = "resources/icons/update-mode.gif";
    private static final String RESOURCES_ICONS_LINK_MODE = "resources/icons/link-mode.gif";
    private static final String EXTENSION = "dot";
    private static final String FORMAT_PDF = "pdf";
    private static final String FORMAT_PNG = "png";
    private boolean exportFromZestGraph = true;
    private boolean listenToDotContent = false;
    private boolean linkImage = false;
    private Composite composite;
    private GraphWidget graph;
    private Graph dotGraph;
    private IFile file;
    private String dotString = "";
    private boolean addReference = true;
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() != 16 && event.getType() != 1) {
                return;
            }
            IResourceDelta rootDelta = event.getDelta();
            try {
                rootDelta.accept(ZestGraphView.this.resourceVisitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    };
    private IResourceDeltaVisitor resourceVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                IFile f;
                block5: {
                    f = (IFile)resource;
                    if (ZestGraphView.this.listenToDotContent || f.getLocation().toString().endsWith(ZestGraphView.EXTENSION)) break block5;
                    return true;
                }
                try {
                    IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            ZestGraphView.this.setGraph(f);
                        }
                    };
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    if (!workspace.isTreeLocked()) {
                        workspace.run(workspaceRunnable, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
    };

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.composite.setLayout((Layout)layout);
        if (this.file != null) {
            try {
                this.updateGraph();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this.addUpdateModeButton();
        this.addLoadButton();
        this.addLayoutButton();
        this.addResetButton();
        this.addExportModeButton();
        this.addExportButton();
        this.addLinkModeButton();
    }

    public GraphWidget getGraph() {
        return this.graph;
    }

    public void setGraph(final String dot, boolean async) {
        this.dotString = dot;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                this.updateZestGraph(dot);
            }

            private void updateZestGraph(String currentDot) {
                if (ZestGraphView.this.graph != null) {
                    ZestGraphView.this.graph.dispose();
                }
                if (!dot.trim().isEmpty() && ZestGraphView.this.composite != null) {
                    DotImport dotImport = new DotImport(ZestGraphView.this.dotString);
                    if (dotImport.getErrors().size() > 0) {
                        String message = String.format("Could not import DOT: %s, DOT: %s", dotImport.getErrors(), ZestGraphView.this.dotString);
                        ZestUiActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gef4.zest.ui", message));
                        return;
                    }
                    ZestGraphView.this.dotGraph = dotImport.newGraphInstance();
                    ZestGraphView.this.graph = new GraphWidget(ZestGraphView.this.dotGraph, ZestGraphView.this.composite, 0);
                    ZestGraphView.this.setupLayout();
                    ZestGraphView.this.composite.layout();
                    ZestGraphView.this.graph.applyLayout();
                    ZestGraphView.this.handleWikiText(currentDot);
                    ZestGraphView.this.linkCorrespondingImage();
                }
            }
        };
        Display display = this.getViewSite().getShell().getDisplay();
        if (async) {
            display.asyncExec(runnable);
        } else {
            display.syncExec(runnable);
        }
    }

    protected void linkCorrespondingImage() {
        boolean canExportFromDot;
        boolean canExportFromZest = this.exportFromZestGraph && this.graph != null;
        boolean bl = canExportFromDot = !this.exportFromZestGraph && this.dotString != null;
        if (this.linkImage && (canExportFromZest || canExportFromDot)) {
            File image = this.generateImageFromGraph(true, FORMAT_PNG);
            this.openFile(image);
        }
    }

    private void addUpdateModeButton() {
        Action toggleUpdateModeAction = new Action(UPDATE_MODE, 2){

            public void run() {
                ZestGraphView.this.listenToDotContent = ZestGraphView.this.toggle(this, ZestGraphView.this.listenToDotContent);
                this.toggleResourceListener();
            }

            private void toggleResourceListener() {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                if (ZestGraphView.this.listenToDotContent) {
                    workspace.addResourceChangeListener(ZestGraphView.this.resourceChangeListener, 17);
                } else {
                    workspace.removeResourceChangeListener(ZestGraphView.this.resourceChangeListener);
                }
            }
        };
        toggleUpdateModeAction.setId(toggleUpdateModeAction.getText());
        toggleUpdateModeAction.setImageDescriptor(ZestUiActivator.getImageDescriptor(RESOURCES_ICONS_UPDATE_MODE));
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)toggleUpdateModeAction);
    }

    private void addExportModeButton() {
        Action toggleRenderingAction = new Action(EXPORT_MODE, 2){

            public void run() {
                ZestGraphView.this.exportFromZestGraph = ZestGraphView.this.toggle(this, ZestGraphView.this.exportFromZestGraph);
            }
        };
        toggleRenderingAction.setId(toggleRenderingAction.getText());
        toggleRenderingAction.setImageDescriptor(ZestUiActivator.getImageDescriptor(RESOURCES_ICONS_EXPORT_MODE));
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)toggleRenderingAction);
    }

    private boolean toggle(Action action, boolean input) {
        action.setChecked(!action.isChecked());
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = mgr.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item.getId() != null && item.getId().equals(action.getText())) {
                ActionContributionItem i = (ActionContributionItem)item;
                i.getAction().setChecked(!i.getAction().isChecked());
                return !input;
            }
            ++n2;
        }
        return input;
    }

    private void addLayoutButton() {
        Action layoutAction = new Action(LAYOUT){

            public void run() {
                if (ZestGraphView.this.graph != null) {
                    ZestGraphView.this.graph.applyLayout();
                }
            }
        };
        layoutAction.setImageDescriptor(ZestUiActivator.getImageDescriptor(RESOURCES_ICONS_LAYOUT));
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)layoutAction);
        mgr.add((IContributionItem)new Separator());
    }

    private void addExportButton() {
        Action exportAction = new Action(EXPORT){

            public void run() {
                if (ZestGraphView.this.exportFromZestGraph && ZestGraphView.this.graph != null || !ZestGraphView.this.exportFromZestGraph && ZestGraphView.this.dotString != null) {
                    File image = ZestGraphView.this.generateImageFromGraph(true, ZestGraphView.FORMAT_PDF);
                    ZestGraphView.this.openFile(image);
                }
            }
        };
        exportAction.setImageDescriptor(ZestUiActivator.getImageDescriptor(RESOURCES_ICONS_EXPORT_GIF));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)exportAction);
    }

    private void openFile(File file) {
        if (this.file == null) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(""));
            if (!(fileStore = fileStore.getChild(file.getAbsolutePath())).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                IWorkbenchPage page = this.getSite().getPage();
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath location = Path.fromOSString((String)file.getAbsolutePath());
            IFile copy = workspace.getRoot().getFileForLocation(location);
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            if (registry.isSystemExternalEditorAvailable(copy.getName())) {
                try {
                    this.getViewSite().getPage().openEditor((IEditorInput)new FileEditorInput(copy), "org.eclipse.ui.systemExternalEditor");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addLinkModeButton() {
        Action linkModeAction = new Action(LINK_MODE, 2){

            public void run() {
                ZestGraphView.this.linkImage = ZestGraphView.this.toggle(this, ZestGraphView.this.linkImage);
            }
        };
        linkModeAction.setId(linkModeAction.getText());
        linkModeAction.setImageDescriptor(ZestUiActivator.getImageDescriptor(RESOURCES_ICONS_LINK_MODE));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)linkModeAction);
    }

    private void addResetButton() {
        Action resetAction = new Action(RESET){

            public void run() {
                DotDirStore.setDotDirPath();
            }
        };
        resetAction.setImageDescriptor(ZestUiActivator.getImageDescriptor(RESOURCES_ICONS_RESET));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)resetAction);
    }

    private void addLoadButton() {
        Action loadAction = new Action(LOAD){

            public void run() {
                Object[] selected;
                IWorkspaceRoot root;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(shell, (IContainer)(root = ResourcesPlugin.getWorkspace().getRoot()), 1);
                if (dialog.open() == 0 && (selected = dialog.getResult()) != null) {
                    ZestGraphView.this.file = (IFile)selected[0];
                    ZestGraphView.this.setGraph(ZestGraphView.this.file);
                }
            }
        };
        loadAction.setImageDescriptor(ZestUiActivator.getImageDescriptor(RESOURCES_ICONS_OPEN_GIF));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)loadAction);
    }

    private void setGraph(IFile file) {
        this.file = file;
        try {
            this.updateGraph();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void updateGraph() throws MalformedURLException {
        String currentDot;
        if (this.file == null || this.file.getLocationURI() == null || !this.file.exists()) {
            return;
        }
        File f = this.file.getRawLocation().makeAbsolute().toFile();
        String string = currentDot = this.dotExtraction() ? new DotExtractor(f).getDotString() : DotFileUtils.read((File)DotFileUtils.resolve((URL)this.file.getLocationURI().toURL()));
        if (currentDot.equals(this.dotString) || currentDot.equals("graph{n1[label=\"no DOT\"]}")) {
            return;
        }
        this.setGraph(currentDot, true);
    }

    private boolean dotExtraction() {
        return !this.file.getName().endsWith(EXTENSION);
    }

    private void handleWikiText(String dot) {
        if (this.file == null) {
            return;
        }
        try {
            IEditorDescriptor editor = IDE.getEditorDescriptor((IFile)this.file);
            if (editor.getId().equals("org.eclipse.mylyn.wikitext.ui.editor.markupEditor")) {
                try {
                    File image = this.generateImageFromGraph(true, FORMAT_PNG);
                    File wikiFile = DotFileUtils.resolve((URL)this.file.getLocationURI().toURL());
                    String imageLinkWiki = this.createImageLinkMarkup(image);
                    if (!DotFileUtils.read((File)wikiFile).contains(imageLinkWiki) && this.addReference && this.supported(this.file)) {
                        String message = String.format(ADD_EXPORT_MESSAGE, this.file.getName());
                        if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)ADD_EXPORT_QUESTION, (String)message)) {
                            this.addReference(dot, wikiFile, imageLinkWiki);
                        } else {
                            this.addReference = false;
                        }
                    }
                    this.refreshParent(this.file);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private boolean supported(IFile wikiFile) {
        return wikiFile.getFileExtension().endsWith("textile");
    }

    private String createImageLinkMarkup(File image) {
        return String.format("\n!%s!\n", image.getName());
    }

    private void addReference(String dot, File wikiFile, String imageLinkWiki) {
        String content = DotFileUtils.read((File)wikiFile).replace(dot, String.valueOf(dot) + "\n" + imageLinkWiki);
        DotFileUtils.write((String)content, (File)wikiFile);
    }

    private void setupLayout() {
        if (this.graph != null) {
            GridData gd = new GridData(1808);
            this.graph.setLayout((Layout)new GridLayout());
            this.graph.setLayoutData((Object)gd);
        }
    }

    private File generateImageFromGraph(boolean refresh, String format) {
        DotExport dotExport = this.exportFromZestGraph ? new DotExport(this.dotGraph) : new DotExport(this.dotString);
        File image = dotExport.toImage(DotDirStore.getDotDirPath(), format, null);
        if (this.file == null) {
            return image;
        }
        try {
            URL url = this.file.getParent().getLocationURI().toURL();
            File copy = DotFileUtils.copySingleFile((File)DotFileUtils.resolve((URL)url), (String)(String.valueOf(this.file.getName()) + "." + format), (File)image);
            return copy;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            if (refresh) {
                this.refreshParent(this.file);
            }
            return image;
        }
    }

    private void refreshParent(IFile file) {
        try {
            file.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        if (this.graph != null) {
            this.graph.dispose();
        }
        if (this.composite != null) {
            this.composite.dispose();
        }
    }

    public void setFocus() {
        if (this.graph != null && !this.graph.isDisposed()) {
            this.graph.setFocus();
        }
    }
}

