/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.gef4.geometry.planar.AbstractPointListBasedGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polyline;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.ShapeUtils;
import org.eclipse.gef4.geometry.utils.PointListUtils;

public class Polygon
extends AbstractPointListBasedGeometry<Polygon>
implements IShape {
    private static final long serialVersionUID = 1L;

    private static Polygon clipEar(Polygon p, int[] ear, ArrayList<Polygon> ears) {
        Point[] points = p.getPoints();
        ears.add(new Polygon(points[ear[0]], points[ear[1]], points[ear[2]]));
        return new Polygon(Polygon.getPointsWithout(points, ear[1]));
    }

    private static int[] findEarVertex(Polygon p) {
        Point[] points = p.getPoints();
        int start = 0;
        while (start < points.length) {
            int end;
            int mid;
            int n = mid = start == points.length - 1 ? 0 : start + 1;
            int n2 = start == points.length - 2 ? 0 : (end = start == points.length - 1 ? 1 : start + 2);
            if (p.contains(new Line(points[start], points[end]))) {
                return new int[]{start, mid, end};
            }
            ++start;
        }
        return null;
    }

    private static Point[] getPointsWithout(Point[] points, int ... indicesToRemove) {
        Point[] rest = new Point[points.length - indicesToRemove.length];
        Arrays.sort(indicesToRemove);
        int i = 0;
        int j = 0;
        while (i < indicesToRemove.length) {
            int r = j;
            while (r < indicesToRemove[i]) {
                rest[r - i] = points[r];
                ++r;
            }
            j = indicesToRemove[i] + 1;
            ++i;
        }
        i = indicesToRemove[indicesToRemove.length - 1] + 1;
        while (i < points.length) {
            rest[i - indicesToRemove.length] = points[i];
            ++i;
        }
        return rest;
    }

    private static void triangulate(Polygon p, ArrayList<Polygon> ears) {
        if (p == null) {
            throw new IllegalArgumentException("The given Polygon may not be null.");
        }
        if (ears == null) {
            throw new IllegalArgumentException("The given ear-list may not be null.");
        }
        if (p.points.length < 3) {
            throw new IllegalArgumentException("The given Polygon may not have less than three vertices.");
        }
        if (p.points.length == 3) {
            ears.add(p.getCopy());
            return;
        }
        int[] ear = Polygon.findEarVertex(p);
        Polygon rest = Polygon.clipEar(p, ear, ears);
        Polygon.triangulate(rest, ears);
    }

    public Polygon(double ... coordinates) {
        super(coordinates);
    }

    public Polygon(Point ... points) {
        super(points);
    }

    private void assureSimplicity() throws NonSimplePolygonException {
        if (this.points.length < 3) {
            throw new NonSimplePolygonException("A polygon can only be constructed of at least 3 vertices.");
        }
        Line[] lineArray = this.getOutlineSegments();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line e1 = lineArray[n2];
            Line[] lineArray2 = this.getOutlineSegments();
            int n3 = lineArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Line e2 = lineArray2[n4];
                if (!(e1.getP1().equals(e2.getP1()) || e1.getP2().equals(e2.getP1()) || e1.getP1().equals(e2.getP2()) || e1.getP2().equals(e2.getP2()) || !e1.touches(e2))) {
                    throw new NonSimplePolygonException("Only simple polygons allowed. A polygon without any self-intersections is considered to be simple. This polygon is not simple.");
                }
                ++n4;
            }
            ++n2;
        }
    }

    public boolean contains(double x, double y) {
        return this.contains(new Point(x, y));
    }

    @Override
    public boolean contains(IGeometry g) {
        if (g instanceof Line) {
            return this.contains((Line)g);
        }
        if (g instanceof Polygon) {
            return this.contains((Polygon)g);
        }
        if (g instanceof Polyline) {
            return this.contains((Polyline)g);
        }
        if (g instanceof Rectangle) {
            return this.contains((Rectangle)g);
        }
        return ShapeUtils.contains((IShape)this, g);
    }

    public boolean contains(Line line) {
        if (!this.contains(line.getP1()) || !this.contains(line.getP2())) {
            return false;
        }
        HashSet<Double> intersectionParams = new HashSet<Double>();
        Line[] lineArray = this.getOutlineSegments();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line seg = lineArray[n2];
            Point poi = seg.getIntersection(line);
            if (poi != null) {
                intersectionParams.add(line.getParameterAt(poi));
            }
            ++n2;
        }
        if (intersectionParams.size() <= 1) {
            return true;
        }
        Double[] poiParams = intersectionParams.toArray(new Double[0]);
        Arrays.sort(poiParams, new Comparator<Double>(){

            @Override
            public int compare(Double t, Double u) {
                double d = t - u;
                return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
            }
        });
        if (!this.contains(line.get(poiParams[0] / 2.0))) {
            return false;
        }
        int i = 0;
        while (i < poiParams.length - 1) {
            if (!this.contains(line.get((poiParams[i] + poiParams[i + 1]) / 2.0))) {
                return false;
            }
            ++i;
        }
        return this.contains(line.get((poiParams[poiParams.length - 1] + 1.0) / 2.0));
    }

    @Override
    public boolean contains(Point p) {
        if (this.points.length == 0) {
            return false;
        }
        if (this.points.length == 1) {
            return this.points[0].equals(p);
        }
        if (this.points.length == 2) {
            return new Line(this.points[0], this.points[1]).contains(p);
        }
        Rectangle bounds = this.getBounds();
        if (!bounds.contains(p)) {
            return false;
        }
        Point pp = new Point(p.x + bounds.getWidth() + 1.0, p.y);
        Line testLine = new Line(p, pp);
        boolean odd = false;
        int i = 0;
        while (i < this.points.length) {
            Point p1 = this.points[i];
            Point p2 = this.points[i + 1 < this.points.length ? i + 1 : 0];
            if (p1.equals(p2)) {
                if (p1.equals(p)) {
                    return true;
                }
            } else {
                Line segment = new Line(p1, p2);
                if (segment.contains(p)) {
                    return true;
                }
                boolean p1contained = testLine.contains(p1);
                boolean p2contained = testLine.contains(p2);
                if (p1contained || p2contained) {
                    if (p1contained && p1.y > p2.y) {
                        boolean bl = odd = !odd;
                    }
                    if (p2contained && p2.y > p1.y) {
                        odd = !odd;
                    }
                } else {
                    Point poi = testLine.getIntersection(segment);
                    if (poi != null && poi.x >= p.x) {
                        odd = !odd;
                    }
                }
            }
            ++i;
        }
        return odd;
    }

    public boolean contains(Polygon p) {
        Line[] otherSegments = p.getOutlineSegments();
        int i = 0;
        while (i < otherSegments.length) {
            if (!this.contains(otherSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(Polyline p) {
        Line[] otherSegments = p.getCurves();
        int i = 0;
        while (i < otherSegments.length) {
            if (!this.contains(otherSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(Rectangle r) {
        return this.contains(r.toPolygon());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Polygon) {
            Polygon p = (Polygon)o;
            return this.equals(p.getPoints());
        }
        return false;
    }

    public boolean equals(Point[] points) {
        SegmentCounter sc;
        Line seg;
        if (points.length != this.points.length) {
            return false;
        }
        SegmentList segments = new SegmentList();
        Line[] lineArray = this.getOutlineSegments();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            seg = lineArray[n2];
            sc = segments.find(seg);
            ++sc.count;
            ++n2;
        }
        lineArray = new Polygon(points).getOutlineSegments();
        n = lineArray.length;
        n2 = 0;
        while (n2 < n) {
            seg = lineArray[n2];
            sc = segments.find(seg);
            if (sc.count == 0) {
                return false;
            }
            --sc.count;
            ++n2;
        }
        return true;
    }

    public double getArea() {
        return Math.abs(this.getSignedArea());
    }

    @Override
    public Polygon getCopy() {
        return new Polygon(this.getPoints());
    }

    @Override
    public Polyline getOutline() {
        return new Polyline(PointListUtils.toSegmentsArray(this.points, true));
    }

    public Line[] getOutlineSegments() {
        return PointListUtils.toSegmentsArray(this.points, true);
    }

    public double getSignedArea() {
        if (this.points.length < 3) {
            return 0.0;
        }
        double area = 0.0;
        int i = 0;
        while (i < this.points.length - 1) {
            area += this.points[i].x * this.points[i + 1].y - this.points[i].y * this.points[i + 1].x;
            ++i;
        }
        return (area += this.points[this.points.length - 1].x * this.points[0].y - this.points[this.points.length - 1].y * this.points[0].x) * 0.5;
    }

    @Override
    public Polygon getTransformed(AffineTransform t) {
        return new Polygon(t.getTransformed(this.points));
    }

    public Polygon[] getTriangulation() throws NonSimplePolygonException {
        this.assureSimplicity();
        ArrayList<Polygon> ears = new ArrayList<Polygon>(this.points.length - 2);
        Polygon.triangulate(this, ears);
        return ears.toArray(new Polygon[0]);
    }

    @Override
    public Path toPath() {
        Path path = new Path();
        if (this.points.length > 0) {
            path.moveTo(this.points[0].x, this.points[0].y);
            int i = 1;
            while (i < this.points.length) {
                path.lineTo(this.points[i].x, this.points[i].y);
                ++i;
            }
            path.close();
        }
        return path;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Polygon: ");
        if (this.points.length > 0) {
            int i = 0;
            while (i < this.points.length) {
                stringBuffer.append("(" + this.points[i].x + ", " + this.points[i].y + ")");
                stringBuffer.append(" -> ");
                ++i;
            }
            stringBuffer.append("(" + this.points[0].x + ", " + this.points[0].y + ")");
        } else {
            stringBuffer.append("<no points>");
        }
        return stringBuffer.toString();
    }

    public class NonSimplePolygonException
    extends RuntimeException {
        public NonSimplePolygonException() {
        }

        public NonSimplePolygonException(String s) {
            super(s);
        }
    }

    private class SegmentCounter {
        public Line segment;
        public int count;

        public SegmentCounter(Line segment, int count) {
            this.segment = segment;
            this.count = count;
        }
    }

    private class SegmentList {
        public ArrayList<SegmentCounter> segmentCounterList = new ArrayList();

        public SegmentCounter find(Line segment) {
            for (SegmentCounter i : this.segmentCounterList) {
                if (!segment.equals(i.segment)) continue;
                return i;
            }
            SegmentCounter newSegCounter = new SegmentCounter(segment, 0);
            this.segmentCounterList.add(newSegCounter);
            return newSegCounter;
        }
    }
}

