/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.layout.algorithms.NodeWrapper;
import org.eclipse.gef4.layout.interfaces.LayerProvider;
import org.eclipse.gef4.layout.interfaces.NodeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLayerProvider
implements LayerProvider {
    private static final int MAX_LAYERS = 10;
    private final List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>(10);
    private final Map<NodeLayout, NodeWrapper> map = new IdentityHashMap<NodeLayout, NodeWrapper>();

    private static List<NodeLayout> findRoots(List<NodeLayout> list) {
        ArrayList<NodeLayout> roots = new ArrayList<NodeLayout>();
        for (NodeLayout iter : list) {
            if (iter.getPredecessingNodes().length != 0) continue;
            roots.add(iter);
        }
        return roots;
    }

    private void addLayer(List<NodeLayout> list) {
        ArrayList<NodeWrapper> layer = new ArrayList<NodeWrapper>(list.size());
        for (NodeLayout node : list) {
            NodeWrapper nw = new NodeWrapper(node, this.layers.size());
            this.map.put(node, nw);
            layer.add(nw);
            NodeLayout[] nodeLayoutArray = node.getPredecessingNodes();
            int n = nodeLayoutArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLayout node_predecessor = nodeLayoutArray[n2];
                NodeWrapper nw_predecessor = this.map.get(node_predecessor);
                if (nw_predecessor != null) {
                    int level = nw_predecessor.layer + 1;
                    while (level < nw.layer) {
                        NodeWrapper nw_dummy = new NodeWrapper(level);
                        nw_dummy.addPredecessor(nw_predecessor);
                        nw_predecessor.addSuccessor(nw_dummy);
                        nw_predecessor = nw_dummy;
                        this.layers.get(level).add(nw_dummy);
                        ++level;
                    }
                    nw.addPredecessor(nw_predecessor);
                    nw_predecessor.addSuccessor(nw);
                }
                ++n2;
            }
        }
        this.layers.add(layer);
        SimpleLayerProvider.updateIndex(layer);
    }

    private static void updateIndex(List<NodeWrapper> list) {
        int index = 0;
        while (index < list.size()) {
            list.get((int)index).index = index;
            ++index;
        }
    }

    @Override
    public List<List<NodeWrapper>> calculateLayers(List<NodeLayout> nodes) {
        this.map.clear();
        List<NodeLayout> predecessors = SimpleLayerProvider.findRoots(nodes);
        nodes.removeAll(predecessors);
        this.addLayer(predecessors);
        int level = 1;
        while (!nodes.isEmpty()) {
            if (level > 10) {
                throw new RuntimeException("Graphical tree exceeds maximum depth of 10! (Graph not directed? Cycles?)");
            }
            ArrayList<NodeLayout> layer = new ArrayList<NodeLayout>();
            for (NodeLayout item : nodes) {
                if (!predecessors.containsAll(Arrays.asList(item.getPredecessingNodes()))) continue;
                layer.add(item);
            }
            if (layer.size() == 0) {
                layer.add(nodes.get(0));
            }
            nodes.removeAll(layer);
            predecessors.addAll(layer);
            this.addLayer(layer);
            ++level;
        }
        return this.layers;
    }
}

