/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.blint.support.contributors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.virgo.bundlor.blint.support.Validator;
import org.eclipse.virgo.bundlor.util.BundleManifestUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public final class VersionedImportsRangeValidator
implements Validator {
    private static final String MESSAGE = "The import of package %s results in an empty range";

    @Override
    public Set<String> validate(ManifestContents manifest) {
        HashSet<String> warnings = new HashSet<String>();
        BundleManifest bundleManifest = BundleManifestUtils.createBundleManifest((ManifestContents)manifest);
        List importedPackages = bundleManifest.getImportPackage().getImportedPackages();
        for (ImportedPackage importedPackage : importedPackages) {
            try {
                if (!importedPackage.getVersion().isEmpty()) continue;
                warnings.add(String.format(MESSAGE, importedPackage.getPackageName()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                warnings.add(String.format(MESSAGE, importedPackage.getPackageName()));
            }
        }
        return warnings;
    }
}

