/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.virgo.bundlor.ClassPath;
import org.eclipse.virgo.bundlor.ClassPathEntry;
import org.eclipse.virgo.bundlor.support.classpath.FileSystemClassPathEntry;

final class FileSystemClassPath
implements ClassPath {
    private final File classPathRoot;

    public FileSystemClassPath(File classPathRoot) {
        this.classPathRoot = classPathRoot;
    }

    @Override
    public ClassPathEntry getEntry(String name) {
        File file = new File(this.classPathRoot, name);
        if (file.exists()) {
            return new FileSystemClassPathEntry(this.classPathRoot, file);
        }
        return null;
    }

    @Override
    public Iterator<ClassPathEntry> iterator() {
        return new FileSystemClassPathIterator(this.classPathRoot);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.classPathRoot.getAbsolutePath();
    }

    private static class FileSystemClassPathIterator
    implements Iterator<ClassPathEntry> {
        private final Iterator<ClassPathEntry> fileSystemIterator;

        public FileSystemClassPathIterator(File root) {
            ArrayList<ClassPathEntry> entries = new ArrayList<ClassPathEntry>();
            this.enumerateEntries(root, root, entries);
            this.fileSystemIterator = entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.fileSystemIterator.hasNext();
        }

        @Override
        public ClassPathEntry next() {
            return this.fileSystemIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void enumerateEntries(File root, File orignalRootPath, List<ClassPathEntry> entries) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.enumerateEntries(file, orignalRootPath, entries);
                } else {
                    String name = file.getAbsolutePath().substring(orignalRootPath.getAbsolutePath().length());
                    name = this.normalizeWindowsPaths(name);
                    name = this.normalizeRootPaths(name);
                    entries.add(new FileSystemClassPathEntry(orignalRootPath, file));
                }
                ++n2;
            }
        }

        private String normalizeWindowsPaths(String name) {
            return name.replace('\\', '/');
        }

        private String normalizeRootPaths(String name) {
            if (name.startsWith("/")) {
                return name.substring(1);
            }
            return name;
        }
    }
}

