/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.facet.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.virgo.ide.facet.core.AbstractOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class CreatePlanProjectOperation
extends AbstractOperation {
    private static final String UTF_8 = "UTF-8";
    private static final String TEMPLATE_PATH = "/org/eclipse/virgo/ide/facet/internal/core/plan_template.xml";
    private static final String WST_FACET_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private final IProject projectHandle;
    private final URI location;
    private final Shell shell;
    private final boolean scoped;
    private final boolean atomic;
    private final String planName;
    private IFile planFile;

    public CreatePlanProjectOperation(IProject projectHandle, URI location, String planName, boolean scoped, boolean atomic, Shell shell) {
        Assert.isNotNull((Object)projectHandle, (String)"projectHandle cannot be null");
        Assert.isNotNull((Object)shell, (String)"shell cannot be null");
        this.projectHandle = projectHandle;
        this.location = location;
        this.shell = shell;
        this.scoped = scoped;
        this.atomic = atomic;
        this.planName = planName;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", this.planName != null ? 4 : 3);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(this.projectHandle.getName());
        description.setLocationURI(this.location);
        CreateProjectOperation op = new CreateProjectOperation(description, "");
        try {
            op.execute((IProgressMonitor)new NullProgressMonitor(), WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.shell));
        }
        catch (ExecutionException e1) {
            CoreException cex = new CoreException((IStatus)new Status(4, "org.eclipse.virgo.server.plan", e1.getMessage()));
            cex.initCause((Throwable)e1);
            throw cex;
        }
        monitor.worked(1);
        description = this.projectHandle.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 3];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        System.arraycopy(new String[]{WST_FACET_NATURE, "org.eclipse.virgo.ide.facet.core.plannature", "org.eclipse.jdt.core.javanature"}, 0, newNatures, natures.length, 3);
        description.setNatureIds(newNatures);
        this.projectHandle.setDescription(description, null);
        monitor.worked(1);
        IJavaProject javaProject = JavaCore.create((IProject)this.projectHandle);
        IFolder binFolder = this.projectHandle.getFolder("bin");
        binFolder.create(false, true, null);
        javaProject.setOutputLocation(binFolder.getFullPath(), null);
        IFolder sourceFolder = this.projectHandle.getFolder("src");
        sourceFolder.create(false, true, null);
        IClasspathEntry sourceEntry = JavaCore.newSourceEntry((IPath)sourceFolder.getFullPath());
        List<IClasspathEntry> entries = Arrays.asList(sourceEntry, JavaRuntime.getDefaultJREContainerEntry());
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)this.projectHandle, (boolean)true, null);
        fProject.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.plan").getDefaultVersion(), null, null);
        monitor.worked(1);
        if (this.planName != null) {
            String content = this.readResourceFromClassPath(TEMPLATE_PATH, UTF_8);
            content = MessageFormat.format(content, this.planName, this.scoped, this.atomic);
            Path p = new Path(this.planName);
            if (!"plan".equals(p.getFileExtension())) {
                p = p.addFileExtension("plan");
            }
            this.planFile = sourceFolder.getFile((IPath)p);
            try {
                this.planFile.create((InputStream)new ByteArrayInputStream(content.getBytes(UTF_8)), true, null);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    public IFile getPlanFile() {
        return this.planFile;
    }
}

