/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.virgo.ide.runtime.core.IServerBehaviour;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class RedeployBundleAction
implements IObjectActionDelegate {
    private IModule selectedModule;
    private IServer server;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.server.getServerState() != 2) {
            return;
        }
        Job publishJob = new Job("Redeploy of module '" + this.selectedModule.getName() + "'"){

            protected IStatus run(IProgressMonitor monitor) {
                IServerBehaviour behaviour = (IServerBehaviour)RedeployBundleAction.this.server.loadAdapter(IServerBehaviour.class, null);
                if ("org.eclipse.virgo.server.par".equals(RedeployBundleAction.this.selectedModule.getModuleType().getId())) {
                    behaviour.getServerDeployer().redeploy(RedeployBundleAction.this.selectedModule);
                } else if ("org.eclipse.virgo.server.bundle".equals(RedeployBundleAction.this.selectedModule.getModuleType().getId())) {
                    List<IModule> modules = Arrays.asList(RedeployBundleAction.this.server.getModules());
                    if (modules.contains(RedeployBundleAction.this.selectedModule)) {
                        behaviour.getServerDeployer().redeploy(RedeployBundleAction.this.selectedModule);
                    } else {
                        for (IModule module : modules) {
                            List<IModule> childModules = Arrays.asList(RedeployBundleAction.this.server.getChildModules(new IModule[]{module}, null));
                            if (!childModules.contains(RedeployBundleAction.this.selectedModule) || !"org.eclipse.virgo.server.par".equals(module.getModuleType().getId())) continue;
                            behaviour.getServerDeployer().refresh(module, new IModule[]{RedeployBundleAction.this.selectedModule});
                        }
                    }
                } else if ("jst.web".equals(RedeployBundleAction.this.selectedModule.getModuleType().getId())) {
                    behaviour.getServerDeployer().redeploy(RedeployBundleAction.this.selectedModule);
                }
                return Status.OK_STATUS;
            }
        };
        publishJob.setPriority(10);
        publishJob.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.selectedModule = null;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)obj;
            this.server = ms.server;
            this.selectedModule = ms.module[ms.module.length - 1];
        }
    }
}

