/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.providers;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiImages;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.ServerFile;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.ServerFileSelection;

public class ServerFileLabelProvider
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final String REMOVE_REGEXP = "org\\.eclipse\\.virgo\\.|\\.properties";
    WorkbenchLabelProvider delegate = new WorkbenchLabelProvider();

    public String getText(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return file.getName().replaceAll(REMOVE_REGEXP, "");
        }
        if (element instanceof File) {
            File file = (File)element;
            return file.getName().replaceAll(REMOVE_REGEXP, "");
        }
        if (element instanceof ServerFileSelection) {
            IFile workspaceFile = ((ServerFile)element).getFile();
            String line = ((ServerFileSelection)element).getLine();
            if (workspaceFile.getFileExtension() != null && workspaceFile.getFileExtension().equals("properties")) {
                workspaceFile.getName();
                if (workspaceFile.getLocation().toPortableString().contains("repository")) {
                    line = String.valueOf(line) + " [User]";
                }
            }
            return line;
        }
        if (element instanceof ServerFile) {
            IFile workspaceFile = ((ServerFile)element).getFile();
            String serverName = workspaceFile.getLocation().lastSegment();
            if (workspaceFile.getFileExtension() != null && workspaceFile.getFileExtension().equals("properties") && workspaceFile.getLocation().toPortableString().contains("repository")) {
                serverName = String.valueOf(serverName) + " [User]";
            }
            return serverName.replaceAll(REMOVE_REGEXP, "");
        }
        return this.delegate.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof ServerFileSelection) {
            return DebugPluginImages.getImage((String)"IMG_OBJS_VARIABLE");
        }
        if (element instanceof ServerFile) {
            return this.getImage(((ServerFile)element).getFile());
        }
        return this.delegate.getImage(element);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof ServerFile) {
            ServerFile serverFile = (ServerFile)element;
            String suffix = " [" + serverFile.getServer() + "] - " + serverFile.getFile().getLocation();
            if (element instanceof ServerFileSelection) {
                suffix = String.valueOf(suffix) + " #" + ((ServerFileSelection)element).getItem();
            }
            decoration.addSuffix(suffix);
            if (!(element instanceof ServerFileSelection)) {
                decoration.addOverlay(ServerUiImages.DESC_OBJ_VIRGO_OVER, 0);
            }
        }
    }
}

