/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.equinox.internal.util.pool.ObjectCreator;
import org.eclipse.equinox.internal.util.pool.ObjectPool;

public final class PrivilegedRunner
implements ObjectCreator {
    private static ObjectPool POOL;

    static {
        try {
            POOL = new ObjectPool(new PrivilegedRunner(), 5, 10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PrivilegedRunner() {
    }

    public static final Object doPrivileged(Object context, PrivilegedDispatcher dispatcher, int type, Object arg1) throws Exception {
        return PrivilegedRunner.doPrivileged(context, dispatcher, type, arg1, null, null, null);
    }

    public static final Object doPrivileged(Object context, PrivilegedDispatcher dispatcher, int type, Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        PA runner = (PA)POOL.getObject();
        runner.dispatcher = dispatcher;
        runner.type = type;
        runner.arg1 = arg1;
        runner.arg2 = arg2;
        runner.arg3 = arg3;
        runner.arg4 = arg4;
        try {
            if (System.getSecurityManager() != null) {
                Object t = context != null ? AccessController.doPrivileged(runner, (AccessControlContext)context) : AccessController.doPrivileged(runner);
                return t;
            }
            Object object = runner.run();
            return object;
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        finally {
            runner.recycle();
            POOL.releaseObject(runner);
        }
    }

    public Object getInstance() throws Exception {
        return new PA();
    }

    static class PA
    implements PrivilegedExceptionAction {
        int type;
        Object arg1;
        Object arg2;
        Object arg3;
        Object arg4;
        PrivilegedDispatcher dispatcher;

        PA() {
        }

        void recycle() {
            this.dispatcher = null;
            this.type = -1;
            this.arg4 = null;
            this.arg3 = null;
            this.arg2 = null;
            this.arg1 = null;
        }

        public Object run() throws Exception {
            return this.dispatcher.dispatchPrivileged(this.type, this.arg1, this.arg2, this.arg3, this.arg4);
        }
    }

    public static interface PrivilegedDispatcher {
        public Object dispatchPrivileged(int var1, Object var2, Object var3, Object var4, Object var5) throws Exception;
    }
}

