/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.util.ArrayList;
import org.apache.felix.gogo.command.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class Inspect {
    public static final String PACKAGE_TYPE = "package";
    public static final String BUNDLE_TYPE = "bundle";
    public static final String FRAGMENT_TYPE = "fragment";
    public static final String SERVICE_TYPE = "service";
    public static final String CAPABILITY = "capability";
    public static final String REQUIREMENT = "requirement";

    public static void inspect(BundleContext bc, String type, String direction, Bundle[] bundles) {
        if (Inspect.isValidType(type) && Inspect.isValidDirection(direction)) {
            if (PACKAGE_TYPE.startsWith(type)) {
                if (CAPABILITY.startsWith(direction)) {
                    Inspect.printExportedPackages(bc, bundles);
                } else {
                    Inspect.printImportedPackages(bc, bundles);
                }
            } else if (BUNDLE_TYPE.startsWith(type)) {
                if (CAPABILITY.startsWith(direction)) {
                    Inspect.printRequiringBundles(bc, bundles);
                } else {
                    Inspect.printRequiredBundles(bc, bundles);
                }
            } else if (FRAGMENT_TYPE.startsWith(type)) {
                if (CAPABILITY.startsWith(direction)) {
                    Inspect.printFragmentHosts(bc, bundles);
                } else {
                    Inspect.printHostedFragments(bc, bundles);
                }
            } else if (CAPABILITY.startsWith(direction)) {
                Inspect.printExportedServices(bc, bundles);
            } else {
                Inspect.printImportedServices(bc, bundles);
            }
        } else {
            if (!Inspect.isValidType(type)) {
                System.out.println("Invalid argument: " + type);
            }
            if (!Inspect.isValidDirection(direction)) {
                System.out.println("Invalid argument: " + direction);
            }
        }
    }

    public static void printExportedPackages(BundleContext bc, Bundle[] bundles) {
        ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
        PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
        if (pa == null) {
            System.out.println("PackageAdmin service is unavailable.");
        } else {
            boolean separatorNeeded = false;
            if (bundles == null || bundles.length == 0) {
                bundles = bc.getBundles();
            }
            for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                try {
                    if (bundles[bundleIdx] == null) continue;
                    ExportedPackage[] exports = pa.getExportedPackages(bundles[bundleIdx]);
                    if (separatorNeeded) {
                        System.out.println("");
                    }
                    String title = bundles[bundleIdx] + " exports packages:";
                    System.out.println(title);
                    System.out.println(Util.getUnderlineString(title.length()));
                    if (exports != null && exports.length > 0) {
                        for (int expIdx = 0; expIdx < exports.length; ++expIdx) {
                            System.out.print(exports[expIdx]);
                            Bundle[] importers = exports[expIdx].getImportingBundles();
                            if (importers == null || importers.length == 0) {
                                System.out.println(" UNUSED");
                                continue;
                            }
                            System.out.println(" imported by:");
                            for (int impIdx = 0; impIdx < importers.length; ++impIdx) {
                                System.out.println("   " + importers[impIdx]);
                            }
                        }
                    } else {
                        System.out.println("Nothing");
                    }
                    separatorNeeded = true;
                    continue;
                }
                catch (Exception ex) {
                    System.err.println(ex.toString());
                }
            }
            Util.ungetServices(bc, refs);
        }
    }

    public static void printImportedPackages(BundleContext bc, Bundle[] bundles) {
        boolean separatorNeeded = false;
        if (bundles == null || bundles.length == 0) {
            bundles = bc.getBundles();
        }
        for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            try {
                if (bundles[bundleIdx] == null) continue;
                if (separatorNeeded) {
                    System.out.println("");
                }
                Inspect._printImportedPackages(bc, bundles[bundleIdx]);
                separatorNeeded = true;
                continue;
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
        }
    }

    private static void _printImportedPackages(BundleContext bc, Bundle bundle) {
        ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
        PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
        if (pa == null) {
            System.out.println("PackageAdmin service is unavailable.");
        } else {
            ExportedPackage[] exports = pa.getExportedPackages((Bundle)null);
            String title = bundle + " imports packages:";
            System.out.println(title);
            System.out.println(Util.getUnderlineString(title.length()));
            boolean found = false;
            for (int expIdx = 0; expIdx < exports.length; ++expIdx) {
                Bundle[] importers = exports[expIdx].getImportingBundles();
                for (int impIdx = 0; importers != null && impIdx < importers.length; ++impIdx) {
                    if (importers[impIdx] != bundle) continue;
                    System.out.println(exports[expIdx] + " -> " + exports[expIdx].getExportingBundle());
                    found = true;
                }
            }
            if (!found) {
                System.out.println("Nothing");
            }
            Util.ungetServices(bc, refs);
        }
    }

    public static void printRequiringBundles(BundleContext bc, Bundle[] bundles) {
        ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
        PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
        if (pa == null) {
            System.out.println("PackageAdmin service is unavailable.");
        } else {
            boolean separatorNeeded = false;
            if (bundles == null || bundles.length == 0) {
                bundles = bc.getBundles();
            }
            for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                try {
                    if (bundles[bundleIdx] == null) continue;
                    RequiredBundle[] rbs = pa.getRequiredBundles(bundles[bundleIdx].getSymbolicName());
                    for (int rbIdx = 0; rbs != null && rbIdx < rbs.length; ++rbIdx) {
                        if (rbs[rbIdx].getBundle() != bundles[bundleIdx]) continue;
                        if (separatorNeeded) {
                            System.out.println("");
                        }
                        String title = bundles[bundleIdx] + " is required by:";
                        System.out.println(title);
                        System.out.println(Util.getUnderlineString(title.length()));
                        if (rbs[rbIdx].getRequiringBundles() != null && rbs[rbIdx].getRequiringBundles().length > 0) {
                            for (int reqIdx = 0; reqIdx < rbs[rbIdx].getRequiringBundles().length; ++reqIdx) {
                                System.out.println(rbs[rbIdx].getRequiringBundles()[reqIdx]);
                            }
                        } else {
                            System.out.println("Nothing");
                        }
                        separatorNeeded = true;
                    }
                    continue;
                }
                catch (Exception ex) {
                    System.err.println(ex.toString());
                }
            }
            Util.ungetServices(bc, refs);
        }
    }

    public static void printRequiredBundles(BundleContext bc, Bundle[] bundles) {
        boolean separatorNeeded = false;
        if (bundles == null || bundles.length == 0) {
            bundles = bc.getBundles();
        }
        for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            try {
                if (bundles[bundleIdx] == null) continue;
                if (separatorNeeded) {
                    System.out.println("");
                }
                Inspect._printRequiredBundles(bc, bundles[bundleIdx]);
                separatorNeeded = true;
                continue;
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
        }
    }

    private static void _printRequiredBundles(BundleContext bc, Bundle bundle) {
        ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
        PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
        if (pa == null) {
            System.out.println("PackageAdmin service is unavailable.");
        } else {
            RequiredBundle[] rbs = pa.getRequiredBundles(null);
            String title = bundle + " requires bundles:";
            System.out.println(title);
            System.out.println(Util.getUnderlineString(title.length()));
            boolean found = false;
            for (int rbIdx = 0; rbIdx < rbs.length; ++rbIdx) {
                Bundle[] requirers = rbs[rbIdx].getRequiringBundles();
                for (int reqIdx = 0; requirers != null && reqIdx < requirers.length; ++reqIdx) {
                    if (requirers[reqIdx] != bundle) continue;
                    System.out.println(rbs[reqIdx]);
                    found = true;
                }
            }
            if (!found) {
                System.out.println("Nothing");
            }
            Util.ungetServices(bc, refs);
        }
    }

    public static void printFragmentHosts(BundleContext bc, Bundle[] bundles) {
        ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
        PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
        if (pa == null) {
            System.out.println("PackageAdmin service is unavailable.");
        } else {
            if (bundles == null || bundles.length == 0) {
                bundles = bc.getBundles();
            }
            for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                if (bundleIdx > 0) {
                    System.out.println("");
                }
                try {
                    if (bundles[bundleIdx] != null && Inspect.isFragment(bundles[bundleIdx])) {
                        String title = bundles[bundleIdx] + " is attached to:";
                        System.out.println(title);
                        System.out.println(Util.getUnderlineString(title.length()));
                        Bundle[] hosts = pa.getHosts(bundles[bundleIdx]);
                        for (int hostIdx = 0; hosts != null && hostIdx < hosts.length; ++hostIdx) {
                            System.out.println(hosts[hostIdx]);
                        }
                        if (hosts != null && hosts.length != 0) continue;
                        System.out.println("Nothing");
                        continue;
                    }
                    if (bundles[bundleIdx] == null || Inspect.isFragment(bundles[bundleIdx])) continue;
                    System.out.println("Bundle " + bundles[bundleIdx] + " is not a fragment.");
                    continue;
                }
                catch (Exception ex) {
                    System.err.println(ex.toString());
                }
            }
            Util.ungetServices(bc, refs);
        }
    }

    public static void printHostedFragments(BundleContext bc, Bundle[] bundles) {
        ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
        PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
        if (pa == null) {
            System.out.println("PackageAdmin service is unavailable.");
        } else {
            if (bundles == null || bundles.length == 0) {
                bundles = bc.getBundles();
            }
            for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                if (bundleIdx > 0) {
                    System.out.println("");
                }
                try {
                    if (bundles[bundleIdx] != null && !Inspect.isFragment(bundles[bundleIdx])) {
                        String title = bundles[bundleIdx] + " hosts:";
                        System.out.println(title);
                        System.out.println(Util.getUnderlineString(title.length()));
                        Bundle[] fragments = pa.getFragments(bundles[bundleIdx]);
                        for (int fragIdx = 0; fragments != null && fragIdx < fragments.length; ++fragIdx) {
                            System.out.println(fragments[fragIdx]);
                        }
                        if (fragments != null && fragments.length != 0) continue;
                        System.out.println("Nothing");
                        continue;
                    }
                    if (bundles[bundleIdx] == null || !Inspect.isFragment(bundles[bundleIdx])) continue;
                    System.out.println("Bundle " + bundles[bundleIdx] + " is a fragment.");
                    continue;
                }
                catch (Exception ex) {
                    System.err.println(ex.toString());
                }
            }
            Util.ungetServices(bc, refs);
        }
    }

    public static void printExportedServices(BundleContext bc, Bundle[] bundles) {
        if (bundles == null || bundles.length == 0) {
            bundles = bc.getBundles();
        }
        for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            if (bundleIdx > 0) {
                System.out.println("");
            }
            try {
                if (bundles[bundleIdx] == null) continue;
                ServiceReference[] refs = bundles[bundleIdx].getRegisteredServices();
                String title = Util.getBundleName(bundles[bundleIdx]) + " provides services:";
                System.out.println(title);
                System.out.println(Util.getUnderlineString(title.length()));
                if (refs == null || refs.length == 0) {
                    System.out.println("Nothing");
                }
                for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
                    String[] keys = refs[refIdx].getPropertyKeys();
                    for (int keyIdx = 0; keys != null && keyIdx < keys.length; ++keyIdx) {
                        Object v = refs[refIdx].getProperty(keys[keyIdx]);
                        System.out.println(keys[keyIdx] + " = " + Util.getValueString(v));
                    }
                    if (refIdx + 1 >= refs.length) continue;
                    System.out.println("----");
                }
                continue;
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
        }
    }

    public static void printImportedServices(BundleContext bc, Bundle[] bundles) {
        if (bundles == null || bundles.length == 0) {
            bundles = bc.getBundles();
        }
        for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            if (bundleIdx > 0) {
                System.out.println("");
            }
            try {
                if (bundles[bundleIdx] == null) continue;
                ServiceReference[] refs = bundles[bundleIdx].getServicesInUse();
                String title = Util.getBundleName(bundles[bundleIdx]) + " requires services:";
                System.out.println(title);
                System.out.println(Util.getUnderlineString(title.length()));
                if (refs == null || refs.length == 0) {
                    System.out.println("Nothing");
                }
                for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
                    System.out.println("Registering bundle = " + refs[refIdx].getBundle());
                    String[] keys = refs[refIdx].getPropertyKeys();
                    for (int keyIdx = 0; keys != null && keyIdx < keys.length; ++keyIdx) {
                        Object v = refs[refIdx].getProperty(keys[keyIdx]);
                        System.out.println(keys[keyIdx] + " = " + Util.getValueString(v));
                    }
                    if (refIdx + 1 >= refs.length) continue;
                    System.out.println("----");
                }
                continue;
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
        }
    }

    private static boolean isValidType(String type) {
        return PACKAGE_TYPE.startsWith(type) || BUNDLE_TYPE.startsWith(type) || FRAGMENT_TYPE.startsWith(type) || SERVICE_TYPE.startsWith(type);
    }

    private static boolean isValidDirection(String direction) {
        return CAPABILITY.startsWith(direction) || REQUIREMENT.startsWith(direction);
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }
}

