/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.Enumeration;
import java.util.Properties;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.handler.AbstractHandlerExceptionResolver;

public class SimpleMappingExceptionResolver
extends AbstractHandlerExceptionResolver {
    public static final String DEFAULT_EXCEPTION_ATTRIBUTE = "exception";
    private Properties exceptionMappings;
    private String defaultErrorView;
    private String exceptionAttribute = "exception";

    public void setExceptionMappings(Properties mappings) {
        this.exceptionMappings = mappings;
    }

    public void setDefaultErrorView(String defaultErrorView) {
        this.defaultErrorView = defaultErrorView;
    }

    public void setExceptionAttribute(String exceptionAttribute) {
        this.exceptionAttribute = exceptionAttribute;
    }

    protected ModelAndView doResolveException(PortletRequest request, MimeResponse response, Object handler, Exception ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving exception from handler [" + handler + "]: " + ex));
        }
        this.logException(ex, request);
        String viewName = this.determineViewName(ex, request);
        if (viewName != null) {
            return this.getModelAndView(viewName, ex, request);
        }
        return null;
    }

    protected String determineViewName(Exception ex, PortletRequest request) {
        String viewName = null;
        if (this.exceptionMappings != null) {
            viewName = this.findMatchingViewName(this.exceptionMappings, ex);
        }
        if (viewName == null && this.defaultErrorView != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolving to default view '" + this.defaultErrorView + "' for exception of type [" + ex.getClass().getName() + "]"));
            }
            viewName = this.defaultErrorView;
        }
        return viewName;
    }

    protected String findMatchingViewName(Properties exceptionMappings, Exception ex) {
        String viewName = null;
        String dominantMapping = null;
        int deepest = Integer.MAX_VALUE;
        Enumeration<?> names = exceptionMappings.propertyNames();
        while (names.hasMoreElements()) {
            String exceptionMapping = (String)names.nextElement();
            int depth = this.getDepth(exceptionMapping, ex);
            if (depth < 0 || depth >= deepest) continue;
            deepest = depth;
            dominantMapping = exceptionMapping;
            viewName = exceptionMappings.getProperty(exceptionMapping);
        }
        if (viewName != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving to view '" + viewName + "' for exception of type [" + ex.getClass().getName() + "], based on exception mapping [" + dominantMapping + "]"));
        }
        return viewName;
    }

    protected int getDepth(String exceptionMapping, Exception ex) {
        return this.getDepth(exceptionMapping, ex.getClass(), 0);
    }

    private int getDepth(String exceptionMapping, Class exceptionClass, int depth) {
        if (exceptionClass.getName().contains(exceptionMapping)) {
            return depth;
        }
        if (exceptionClass.equals(Throwable.class)) {
            return -1;
        }
        return this.getDepth(exceptionMapping, exceptionClass.getSuperclass(), depth + 1);
    }

    protected ModelAndView getModelAndView(String viewName, Exception ex, PortletRequest request) {
        return this.getModelAndView(viewName, ex);
    }

    protected ModelAndView getModelAndView(String viewName, Exception ex) {
        ModelAndView mv = new ModelAndView(viewName);
        if (this.exceptionAttribute != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Exposing Exception as model attribute '" + this.exceptionAttribute + "'"));
            }
            mv.addObject(this.exceptionAttribute, ex);
        }
        return mv;
    }
}

