/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;

public abstract class LoginAuthenticator
implements Authenticator {
    public static final String SESSION_SECURED = "org.eclipse.jetty.security.secured";
    protected final DeferredAuthentication _deferred = new DeferredAuthentication(this);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + this + " in " + configuration);
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + this + " in " + configuration);
        }
        this._renewSession = configuration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSessionOnAuthentication(HttpServletRequest request, HttpServletResponse response) {
        HttpSession httpSession = request.getSession(false);
        if (this._renewSession && httpSession != null && httpSession.getAttribute(SESSION_SECURED) == null) {
            LoginAuthenticator loginAuthenticator = this;
            synchronized (loginAuthenticator) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                Enumeration e = httpSession.getAttributeNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    attributes.put(name, httpSession.getAttribute(name));
                    httpSession.removeAttribute(name);
                }
                httpSession.invalidate();
                httpSession = request.getSession(true);
                httpSession.setAttribute(SESSION_SECURED, (Object)Boolean.TRUE);
                for (Map.Entry entry : attributes.entrySet()) {
                    httpSession.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
        }
        return httpSession;
    }
}

