/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.core.internal.blueprint;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.core.internal.blueprint.Ticker;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public final class StandardTicker<V>
implements Ticker,
Callable<V> {
    private static final long OVERDUE = -1L;
    private final long creationTimeMillis;
    private long lastTickMillis;
    private final Ticker.HeartBeatPolicy heartBeatPolicy;
    private long heartBeatIntervalMillis;
    private boolean tickedAtLeastOnce;
    private boolean cancelled;
    private ScheduledFuture<V> scheduledFuture;
    private final Callable<V> action;
    private final ScheduledExecutorService scheduledExecutorService;
    private Object monitor;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public static <V> Ticker createTicker(Ticker.HeartBeatPolicy heartBeatPolicy, Callable<V> action, ScheduledExecutorService scheduledExecutorService) {
        try {
            StandardTicker<V> standardTicker;
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                StandardTicker<V> ticker = new StandardTicker<V>(heartBeatPolicy, action, scheduledExecutorService);
                super.start();
                standardTicker = ticker;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return standardTicker;
        }
        catch (Throwable throwable) {
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public static <V> Ticker createExponentialTicker(long initialHeartbeatIntervalMillis, long heartBeatIncreasePercentage, long maxHeartBeatIntervalMillis, Callable<V> action, ScheduledExecutorService scheduledExecutorService) {
        try {
            Ticker ticker;
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            try {
                ticker = StandardTicker.createTicker(new ExponentialHeartBeatPolicy(initialHeartbeatIntervalMillis, heartBeatIncreasePercentage, maxHeartBeatIntervalMillis), action, scheduledExecutorService);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return ticker;
        }
        catch (Throwable throwable) {
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private StandardTicker(Ticker.HeartBeatPolicy heartBeatPolicy, Callable<V> action, ScheduledExecutorService scheduledExecutorService) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.tickedAtLeastOnce = false;
            this.cancelled = false;
            this.monitor = new Object();
            this.heartBeatPolicy = heartBeatPolicy;
            this.heartBeatIntervalMillis = this.heartBeatPolicy.getNextHeartBeatIntervalMillis();
            this.lastTickMillis = this.creationTimeMillis = System.currentTimeMillis();
            this.action = action;
            this.scheduledExecutorService = scheduledExecutorService;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void start() {
        try {
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                if (this.getIntervalToNextTickMillis() == -1L) {
                    try {
                        this.call();
                    }
                    catch (Exception exception) {}
                } else {
                    this.scheduleNextTick();
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextTick() {
        try {
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                Object object = this.monitor;
                synchronized (object) {
                    if (!this.cancelled) {
                        this.scheduledFuture = this.scheduledExecutorService.schedule(this, this.getIntervalToNextTickMillis(), TimeUnit.MILLISECONDS);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    @Override
    public V call() throws Exception {
        try {
            V v;
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            try {
                boolean ticked = this.tick();
                this.scheduleNextTick();
                v = ticked ? (V)this.action.call() : null;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return v;
        }
        catch (Throwable throwable) {
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        try {
            boolean bl;
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            try {
                Object object = this.monitor;
                synchronized (object) {
                    this.cancelled = true;
                    this.scheduledFuture.cancel(true);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                    bl = this.tickedAtLeastOnce;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return bl;
        }
        catch (Throwable throwable) {
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tick() {
        try {
            boolean bl;
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            try {
                Object object = this.monitor;
                synchronized (object) {
                    boolean ticked = false;
                    if (!this.cancelled && this.getIntervalToNextTickMillis() == -1L) {
                        ticked = true;
                        this.lastTickMillis = this.getCurrentTimeMillis();
                        this.heartBeatIntervalMillis = this.heartBeatPolicy.getNextHeartBeatIntervalMillis();
                    }
                    this.tickedAtLeastOnce = this.tickedAtLeastOnce || ticked;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                    bl = ticked;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return bl;
        }
        catch (Throwable throwable) {
            StandardTicker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private long getCurrentTimeMillis() {
        try {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < this.lastTickMillis) {
                throw new IllegalArgumentException("Time must not go backwards");
            }
            return currentTimeMillis;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIntervalToNextTickMillis() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                long intervalSinceLastTickMillis = this.getCurrentTimeMillis() - this.lastTickMillis;
                return intervalSinceLastTickMillis < this.heartBeatIntervalMillis ? this.heartBeatIntervalMillis - intervalSinceLastTickMillis : -1L;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("StandardTicker.java", Class.forName("org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createTicker", "org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker", "org.eclipse.virgo.kernel.core.internal.blueprint.Ticker$HeartBeatPolicy:java.util.concurrent.Callable:java.util.concurrent.ScheduledExecutorService:", "heartBeatPolicy:action:scheduledExecutorService:", "", "org.eclipse.virgo.kernel.core.internal.blueprint.Ticker"), 69);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createExponentialTicker", "org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker", "long:long:long:java.util.concurrent.Callable:java.util.concurrent.ScheduledExecutorService:", "initialHeartbeatIntervalMillis:heartBeatIncreasePercentage:maxHeartBeatIntervalMillis:action:scheduledExecutorService:", "", "org.eclipse.virgo.kernel.core.internal.blueprint.Ticker"), 88);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "start", "org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker", "", "", "", "void"), 114);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scheduleNextTick", "org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker", "", "", "", "void"), 128);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "call", "org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker", "", "", "java.lang.Exception:", "java.lang.Object"), 139);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancel", "org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker", "", "", "", "boolean"), 148);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "tick", "org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker", "", "", "", "boolean"), 162);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker");
    }

    private static final class ExponentialHeartBeatPolicy
    implements Ticker.HeartBeatPolicy {
        private final long maxHeartBeatIntervalMillis;
        private final long heartBeatIncreasePercentage;
        private AtomicLong heartBeatIntervalMillis;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public ExponentialHeartBeatPolicy(long initialHeartbeatIntervalMillis, long heartBeatIncreasePercentage, long maxHeartBeatIntervalMillis) {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.heartBeatIntervalMillis = new AtomicLong(initialHeartbeatIntervalMillis);
                this.heartBeatIncreasePercentage = heartBeatIncreasePercentage;
                this.maxHeartBeatIntervalMillis = maxHeartBeatIntervalMillis;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public long getNextHeartBeatIntervalMillis() {
            try {
                boolean success = false;
                long nextHeartBeatIntervalMillis = 0L;
                while (!success) {
                    nextHeartBeatIntervalMillis = this.heartBeatIntervalMillis.get();
                    if (nextHeartBeatIntervalMillis < this.maxHeartBeatIntervalMillis) {
                        long newHeartBeatIntervalMillis = Math.min(nextHeartBeatIntervalMillis * (100L + this.heartBeatIncreasePercentage) / 100L, this.maxHeartBeatIntervalMillis);
                        success = this.heartBeatIntervalMillis.compareAndSet(nextHeartBeatIntervalMillis, newHeartBeatIntervalMillis);
                        continue;
                    }
                    success = true;
                }
                return nextHeartBeatIntervalMillis;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker$ExponentialHeartBeatPolicy");
        }
    }
}

