/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.configuration;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.configuration.ExternalStorageRepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.RemoteRepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.RepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.RepositoryConfigurationException;
import org.eclipse.virgo.repository.configuration.WatchedStorageRepositoryConfiguration;
import org.eclipse.virgo.repository.internal.RepositoryLogEvents;
import org.eclipse.virgo.util.common.StringUtils;
import org.eclipse.virgo.util.math.OrderedPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesRepositoryConfigurationReader {
    private static final String REPOSITORY_CHAIN_KEY = "chain";
    private static final String TYPE_SUFFIX = ".type";
    private static final String EXTERNAL_TYPE = "external";
    private static final String SEARCH_PATTERN_SUFFIX = ".searchPattern";
    private static final String WATCHED_TYPE = "watched";
    private static final String WATCH_DIRECTORY_SUFFIX = ".watchDirectory";
    private static final String WATCH_INTERVAL_SUFFIX = ".watchInterval";
    private static final String REMOTE_TYPE = "remote";
    private static final String URI_SUFFIX = ".uri";
    private static final String INDEX_REFRESH_INTERVAL_SUFFIX = ".indexRefreshInterval";
    private static final Pattern PROPERTY_PATTERN;
    private static final Pattern CONFIG_PATTERN;
    private static final int DEFAULT_INDEX_REFRESH_INTERVAL = 30;
    private static final int DEFAULT_WATCH_INTERVAL = 5;
    private final EventLogger eventLogger;
    private final File indexDirectory;
    private final Set<ArtifactBridge> artifactBridges;
    private final String mBeanDomain;
    private final File rootDirectory;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.configuration.PropertiesRepositoryConfigurationReader");
        PROPERTY_PATTERN = Pattern.compile("(\\$\\{(([^\\}]+))\\})");
        CONFIG_PATTERN = Pattern.compile("(.*)\\.(.*)");
    }

    public PropertiesRepositoryConfigurationReader(File indexDirectory, Set<ArtifactBridge> artifactBridges, EventLogger eventLogger, String mBeanDomain) {
        this(indexDirectory, artifactBridges, eventLogger, mBeanDomain, new File("."));
    }

    public PropertiesRepositoryConfigurationReader(File indexDirectory, Set<ArtifactBridge> artifactBridges, EventLogger eventLogger, String mBeanDomain, File rootDirectory) {
        this.indexDirectory = indexDirectory;
        this.artifactBridges = artifactBridges;
        this.eventLogger = eventLogger;
        this.mBeanDomain = mBeanDomain;
        this.rootDirectory = rootDirectory;
    }

    public OrderedPair<Map<String, RepositoryConfiguration>, List<String>> readConfiguration(Properties configuration) throws RepositoryConfigurationException {
        Map<String, RepositoryConfiguration> repositoryConfigurations = this.readRepositoriesConfiguration(configuration);
        List<String> chainList = this.readChainConfiguration(configuration, repositoryConfigurations);
        return new OrderedPair(repositoryConfigurations, chainList);
    }

    private List<String> readChainConfiguration(Properties configuration, Map<String, RepositoryConfiguration> repositoryConfigurations) {
        String chainProperty = configuration.getProperty(REPOSITORY_CHAIN_KEY);
        ArrayList<String> chainList = new ArrayList<String>();
        if (chainProperty == null) {
            return chainList;
        }
        String[] stringArray = StringUtils.commaDelimitedListToStringArray((String)chainProperty);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String repositoryName = stringArray[n2];
            if (repositoryConfigurations.containsKey(repositoryName)) {
                if (chainList.contains(repositoryName)) {
                    this.eventLogger.log((LogEvent)RepositoryLogEvents.DUPLICATE_REPOSITORY_IN_CHAIN, new Object[]{repositoryName});
                } else {
                    chainList.add(repositoryName);
                }
            } else {
                this.eventLogger.log((LogEvent)RepositoryLogEvents.CHAIN_REFERENCES_MISSING_REPOSITORY, new Object[]{repositoryName});
            }
            ++n2;
        }
        return chainList;
    }

    private Map<String, RepositoryConfiguration> readRepositoriesConfiguration(Properties configuration) {
        HashMap<String, RepositoryConfiguration> configurations = new HashMap<String, RepositoryConfiguration>();
        for (String repositoryName : this.getRepositoryNames(configuration)) {
            RepositoryConfiguration repositoryConfiguration = this.readRepositoryConfiguration(repositoryName, configuration);
            if (repositoryConfiguration == null) continue;
            configurations.put(repositoryConfiguration.getName(), repositoryConfiguration);
        }
        return configurations;
    }

    private RepositoryConfiguration readRepositoryConfiguration(String repositoryName, Properties configuration) {
        String type = configuration.getProperty(String.valueOf(repositoryName) + TYPE_SUFFIX);
        if (type != null) {
            if (EXTERNAL_TYPE.equals(type)) {
                return this.readExternalRepositoryConfiguration(repositoryName, configuration);
            }
            if (REMOTE_TYPE.equals(type)) {
                return this.readRemoteRepositoryConfiguration(repositoryName, configuration);
            }
            if (WATCHED_TYPE.equals(type)) {
                return this.readWatchedRepositoryConfiguration(repositoryName, configuration);
            }
            this.eventLogger.log((LogEvent)RepositoryLogEvents.UNKNOWN_REPOSITORY_TYPE, new Object[]{type, repositoryName});
        } else {
            this.eventLogger.log((LogEvent)RepositoryLogEvents.NO_REPOSITORY_TYPE, new Object[]{repositoryName});
        }
        return null;
    }

    private ExternalStorageRepositoryConfiguration readExternalRepositoryConfiguration(String repositoryName, Properties configuration) {
        String searchPattern = configuration.getProperty(String.valueOf(repositoryName) + SEARCH_PATTERN_SUFFIX);
        if (searchPattern != null) {
            searchPattern = this.convertPath(searchPattern);
            searchPattern = this.makeAbsoluteIfNecessary(searchPattern);
            return new ExternalStorageRepositoryConfiguration(repositoryName, new File(this.indexDirectory, String.valueOf(repositoryName) + ".index"), this.artifactBridges, searchPattern, this.mBeanDomain);
        }
        this.eventLogger.log((LogEvent)RepositoryLogEvents.MISSING_SPECIFICATION, new Object[]{repositoryName, EXTERNAL_TYPE, SEARCH_PATTERN_SUFFIX});
        return null;
    }

    private RemoteRepositoryConfiguration readRemoteRepositoryConfiguration(String repositoryName, Properties configuration) {
        String uri = this.expandProperties(configuration.getProperty(String.valueOf(repositoryName) + URI_SUFFIX));
        if (uri != null) {
            String refreshIntervalProperty = String.valueOf(repositoryName) + INDEX_REFRESH_INTERVAL_SUFFIX;
            int indexRefreshInterval = this.readIntProperty(refreshIntervalProperty, configuration, 30);
            File cacheDirectory = this.getCacheDirectory();
            return new RemoteRepositoryConfiguration(repositoryName, new File(this.indexDirectory, String.valueOf(repositoryName) + ".index"), URI.create(uri), indexRefreshInterval, this.mBeanDomain, cacheDirectory);
        }
        this.eventLogger.log((LogEvent)RepositoryLogEvents.MISSING_SPECIFICATION, new Object[]{repositoryName, REMOTE_TYPE, URI_SUFFIX});
        return null;
    }

    private File getCacheDirectory() {
        return new File(this.indexDirectory, "cache");
    }

    private WatchedStorageRepositoryConfiguration readWatchedRepositoryConfiguration(String repositoryName, Properties configuration) {
        String watchDirPath = this.expandProperties(configuration.getProperty(String.valueOf(repositoryName) + WATCH_DIRECTORY_SUFFIX));
        if (watchDirPath != null) {
            watchDirPath = this.makeAbsoluteIfNecessary(watchDirPath);
            String watchIntervalProperty = String.valueOf(repositoryName) + WATCH_INTERVAL_SUFFIX;
            int watchInterval = this.readIntProperty(watchIntervalProperty, configuration, 5);
            return new WatchedStorageRepositoryConfiguration(repositoryName, new File(this.indexDirectory, String.valueOf(repositoryName) + ".index"), this.artifactBridges, watchDirPath, watchInterval, this.mBeanDomain);
        }
        return null;
    }

    private int readIntProperty(String propertyKey, Properties configuration, int defaultValue) {
        String propertyValue = this.expandProperties(configuration.getProperty(propertyKey));
        if (propertyValue != null) {
            try {
                return Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.eventLogger.log((LogEvent)RepositoryLogEvents.MALFORMED_INT_PROPERTY, new Object[]{propertyValue, propertyKey, defaultValue});
            }
        }
        return defaultValue;
    }

    private Set<String> getRepositoryNames(Properties configuration) {
        HashSet<String> repositoryNames = new HashSet<String>();
        for (Object propertyName : configuration.keySet()) {
            String repositoryName;
            Matcher matcher;
            if ("service.pid".equals(propertyName) || REPOSITORY_CHAIN_KEY.equals(propertyName) || !(matcher = CONFIG_PATTERN.matcher((String)propertyName)).find() || (repositoryName = matcher.group(1)) == null) continue;
            repositoryNames.add(repositoryName);
        }
        return repositoryNames;
    }

    public static String convertToAntStylePath(String searchPath) {
        return searchPath.replaceAll("\\{[^\\}]+\\}", "*");
    }

    private String expandProperties(String value) {
        if (value == null) {
            return value;
        }
        Pattern regex = PROPERTY_PATTERN;
        StringBuffer buffer = new StringBuffer(value.length());
        Matcher matcher = regex.matcher(value);
        int propertyGroup = matcher.groupCount();
        String property = "";
        while (matcher.find()) {
            String key = matcher.group(propertyGroup);
            property = "";
            if (key.contains("::")) {
                String[] keyDefault = key.split("::");
                property = System.getProperty(keyDefault[0]);
                property = property == null ? keyDefault[1] : property.replace('\\', '/');
            } else {
                String systemProperty = System.getProperty(matcher.group(propertyGroup));
                if (systemProperty != null) {
                    property = systemProperty.replace('\\', '/');
                }
            }
            matcher.appendReplacement(buffer, property);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String convertPath(String path) {
        return PropertiesRepositoryConfigurationReader.convertToAntStylePath(this.expandProperties(path));
    }

    private String makeAbsoluteIfNecessary(String path) {
        String absolutePathPattern = !path.startsWith("/") && path.indexOf(":") <= 0 ? String.valueOf(this.rootDirectory.getAbsolutePath()) + File.separator + path : path;
        if (File.separator.equals("/")) {
            return absolutePathPattern.replace('\\', '/');
        }
        return absolutePathPattern.replace('/', '\\');
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

