/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.common;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.virgo.util.common.SynchronizedCollection;
import org.eclipse.virgo.util.common.SynchronizedListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedList<T>
extends SynchronizedCollection<T>
implements List<T> {
    final Object monitor;
    private final List<T> list;

    public SynchronizedList(List<? extends T> list, Object monitor) {
        super(list, monitor);
        this.monitor = monitor;
        this.list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        Object object = this.monitor;
        synchronized (object) {
            this.list.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        Object object = this.monitor;
        synchronized (object) {
            return this.list.addAll(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        Object object = this.monitor;
        synchronized (object) {
            return this.list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        Object object = this.monitor;
        synchronized (object) {
            return this.list.indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        Object object = this.monitor;
        synchronized (object) {
            return this.list.lastIndexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator() {
        Object object = this.monitor;
        synchronized (object) {
            return new SynchronizedListIterator<T>(this.list.listIterator(), this.monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator(int index) {
        Object object = this.monitor;
        synchronized (object) {
            return new SynchronizedListIterator<T>(this.list.listIterator(index), this.monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        Object object = this.monitor;
        synchronized (object) {
            return this.list.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        Object object = this.monitor;
        synchronized (object) {
            return this.list.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        Object object = this.monitor;
        synchronized (object) {
            return new SynchronizedList<T>(this.list.subList(fromIndex, toIndex), this.monitor);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

