/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.dump.impl.thread;

import java.io.PrintWriter;
import java.lang.management.ThreadInfo;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.dump.impl.thread.Java5ThreadInfoWriter;
import org.eclipse.virgo.medic.dump.impl.thread.Java5ThreadMXBeanDelegate;
import org.eclipse.virgo.medic.dump.impl.thread.StandardThreadInfoWriter;
import org.eclipse.virgo.medic.dump.impl.thread.StandardThreadMXBeanDelegate;
import org.eclipse.virgo.medic.dump.impl.thread.ThreadInfoWriter;
import org.eclipse.virgo.medic.dump.impl.thread.ThreadMXBeanDelegate;

public class ThreadDumpContributor
implements DumpContributor {
    private final ThreadMXBeanDelegate threadBeanDelegate;
    private final ThreadInfoWriter threadInfoWriter;

    public ThreadDumpContributor(ThreadMXBeanDelegate threadBeanDelegate, ThreadInfoWriter threadInfoPrinter) {
        this.threadBeanDelegate = threadBeanDelegate;
        this.threadInfoWriter = threadInfoPrinter;
    }

    public ThreadDumpContributor() {
        String javaSpecificationVersion = System.getProperty("java.specification.version");
        if ("1.5".equals(javaSpecificationVersion)) {
            this.threadBeanDelegate = new Java5ThreadMXBeanDelegate();
            this.threadInfoWriter = new Java5ThreadInfoWriter();
        } else {
            this.threadBeanDelegate = new StandardThreadMXBeanDelegate();
            this.threadInfoWriter = new StandardThreadInfoWriter();
        }
    }

    public String getName() {
        return "thread";
    }

    public void contribute(Dump dump) throws DumpContributionFailedException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(dump.createFileWriter("thread.txt"));
            this.processDeadlocks(writer);
            this.processAllThreads(writer);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void processDeadlocks(PrintWriter dump) {
        dump.println("Deadlocked Threads");
        dump.println("==================");
        long[] deadlockedThreadIds = this.threadBeanDelegate.findDeadlockedThreads();
        if (deadlockedThreadIds != null) {
            this.dumpThreads(dump, this.threadBeanDelegate.getThreadInfo(deadlockedThreadIds));
        }
    }

    private void processAllThreads(PrintWriter dump) {
        dump.println();
        dump.println("All Threads");
        dump.println("===========");
        this.dumpThreads(dump, this.threadBeanDelegate.dumpAllThreads());
    }

    private void dumpThreads(PrintWriter dump, ThreadInfo[] infos) {
        ThreadInfo[] threadInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo info = threadInfoArray[n2];
            dump.println();
            this.threadInfoWriter.write(info, dump);
            ++n2;
        }
    }
}

