/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.internal.cm;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.osgi.config.internal.util.MethodUtils;
import org.springframework.osgi.util.internal.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class UpdateMethodAdapter {
    private static final Log log = LogFactory.getLog((Class)UpdateMethodAdapter.class);
    private final Map methods;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Dictionary;

    static Map determineUpdateMethod(final Class target, final String methodName) {
        Assert.notNull((Object)target);
        Assert.notNull((Object)methodName);
        final LinkedHashMap methods = new LinkedHashMap(2);
        final boolean trace = log.isTraceEnabled();
        org.springframework.util.ReflectionUtils.doWithMethods((Class)target, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Class<?> propertiesType;
                Class<?>[] args;
                if (!MethodUtils.isBridge(method) && Modifier.isPublic(method.getModifiers()) && Void.TYPE.equals(method.getReturnType()) && methodName.equals(method.getName()) && (args = method.getParameterTypes()) != null && args.length == 1 && ((propertiesType = args[0]).isAssignableFrom(class$java$util$Map == null ? (class$java$util$Map = UpdateMethodAdapter.class$("java.util.Map")) : class$java$util$Map) || propertiesType.isAssignableFrom(class$java$util$Dictionary == null ? (class$java$util$Dictionary = UpdateMethodAdapter.class$("java.util.Dictionary")) : class$java$util$Dictionary))) {
                    Method m;
                    if (trace) {
                        log.trace((Object)("Discovered custom method [" + method.toString() + "] on " + target));
                    }
                    if ((m = (Method)methods.get(propertiesType)) != null) {
                        if (trace) {
                            log.trace((Object)("Type " + propertiesType + " already has an associated method [" + m.toString() + "];ignoring " + method));
                        }
                    } else {
                        methods.put(propertiesType, method);
                    }
                }
            }
        });
        return methods;
    }

    static void invokeCustomMethods(Object target, Map methods, Map properties) {
        if (methods != null && !methods.isEmpty()) {
            boolean trace = log.isTraceEnabled();
            Object[] args = new Object[]{properties};
            Iterator iterator = methods.values().iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                if (trace) {
                    log.trace((Object)("Invoking listener custom method " + method));
                }
                try {
                    ReflectionUtils.invokeMethod(method, target, args);
                }
                catch (Exception ex) {
                    Exception cause = ReflectionUtils.getInvocationException(ex);
                    log.warn((Object)("Custom method [" + method + "] threw exception when passing properties [" + properties + "]"), (Throwable)cause);
                }
            }
        }
    }

    UpdateMethodAdapter(String methodName, Class type) {
        this.methods = UpdateMethodAdapter.determineUpdateMethod(type, methodName);
    }

    void invoke(Object instance, Map properties) {
        UpdateMethodAdapter.invokeCustomMethods(instance, this.methods, properties);
    }
}

