/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.threadio;

import java.io.IOException;
import java.io.InputStream;

public class ThreadInputStream
extends InputStream {
    ThreadLocal<InputStream> map = new InheritableThreadLocal<InputStream>();
    InputStream dflt;

    public ThreadInputStream(InputStream in) {
        this.dflt = in;
    }

    private InputStream getCurrent() {
        InputStream in = this.map.get();
        if (in != null) {
            return in;
        }
        return this.dflt;
    }

    public void setStream(InputStream in) {
        if (in != this.dflt && in != this) {
            this.map.set(in);
        } else {
            this.map.remove();
        }
    }

    public void end() {
        this.map.remove();
    }

    public InputStream getRoot() {
        return this.dflt;
    }

    public int read() throws IOException {
        return this.getCurrent().read();
    }

    public int read(byte[] b) throws IOException {
        return this.getCurrent().read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.getCurrent().read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.getCurrent().skip(n);
    }

    public int available() throws IOException {
        return this.getCurrent().available();
    }

    public void close() throws IOException {
        this.getCurrent().close();
    }

    public void mark(int readlimit) {
        this.getCurrent().mark(readlimit);
    }

    public void reset() throws IOException {
        this.getCurrent().reset();
    }

    public boolean markSupported() {
        return this.getCurrent().markSupported();
    }
}

