/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public final class PDataStream {
    public static void writeInt(int i, OutputStream os) throws IOException {
        os.write(i >>> 24 & 0xFF);
        os.write(i >>> 16 & 0xFF);
        os.write(i >>> 8 & 0xFF);
        os.write(i & 0xFF);
    }

    public static void writeLong(long l, OutputStream os) throws IOException {
        os.write((int)(l >>> 56) & 0xFF);
        os.write((int)(l >>> 48) & 0xFF);
        os.write((int)(l >>> 40) & 0xFF);
        os.write((int)(l >>> 32) & 0xFF);
        os.write((int)(l >>> 24) & 0xFF);
        os.write((int)(l >>> 16) & 0xFF);
        os.write((int)(l >>> 8) & 0xFF);
        os.write((int)(l & 0xFFL));
    }

    public static void writeShort(short s, OutputStream os) throws IOException {
        os.write(s >>> 8 & 0xFF);
        os.write(s & 0xFF);
    }

    public static void writeChar(char ch, OutputStream os) throws IOException {
        os.write(ch >>> 8 & 0xFF);
        os.write(ch & 0xFF);
    }

    public static void writeBoolean(boolean b, OutputStream os) throws IOException {
        os.write(b ? 1 : 0);
    }

    public static void writeByte(byte b, OutputStream os) throws IOException {
        os.write(b);
    }

    public static void writeBytes(String str, OutputStream os) throws IOException {
        byte[] b = str.getBytes();
        os.write(b);
    }

    public static void writeString(String str, OutputStream os) throws IOException {
        if (str == null) {
            PDataStream.writeBoolean(false, os);
        } else {
            PDataStream.writeBoolean(true, os);
            PDataStream.writeUTF(str, os);
        }
    }

    public static void writeUTF(String str, OutputStream os) throws IOException {
        char ch;
        int strlen = str.length();
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            ch = str.charAt(i);
            utflen = ch >= '\u0001' && ch <= '\u007f' ? ++utflen : (ch > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        os.write(utflen >>> 8 & 0xFF);
        os.write(utflen & 0xFF);
        i = 0;
        while (i < strlen) {
            ch = str.charAt(i);
            if (ch >= '\u0001' && ch <= '\u007f') {
                os.write(ch);
            } else if (ch > '\u07ff') {
                os.write(0xE0 | ch >> 12 & 0xF);
                os.write(0x80 | ch >> 6 & 0x3F);
                os.write(0x80 | ch & 0x3F);
            } else {
                os.write(0xC0 | ch >> 6 & 0x1F);
                os.write(0x80 | ch & 0x3F);
            }
            ++i;
        }
    }

    public static void writeChars(String str, OutputStream os) throws IOException {
        int len = str.length();
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            os.write(ch >>> 8 & 0xFF);
            os.write(ch & 0xFF);
            ++i;
        }
    }

    public static void writeDouble(double d, OutputStream os) throws IOException {
        PDataStream.writeLong(Double.doubleToLongBits(d), os);
    }

    public static void writeFloat(float f, OutputStream os) throws IOException {
        PDataStream.writeInt(Float.floatToIntBits(f), os);
    }

    public static int readInt(InputStream is) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read()) | (ch3 = is.read()) | (ch4 = is.read())) < 0) {
            throw new IOException("Read Error");
        }
        return ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4;
    }

    public static char readChar(InputStream is) throws IOException {
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read())) < 0) {
            throw new IOException("Read Error");
        }
        return (char)(ch1 << 8 | ch2);
    }

    public static short readShort(InputStream is) throws IOException {
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read())) < 0) {
            throw new IOException("Read Error");
        }
        return (short)(ch1 << 8 | ch2);
    }

    public static long readLong(InputStream is) throws IOException {
        return (long)PDataStream.readInt(is) << 32 | (long)PDataStream.readInt(is) & 0xFFFFFFFFL;
    }

    public static boolean readBoolean(InputStream is) throws IOException {
        int ch = is.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public static byte readByte(InputStream is) throws IOException {
        int ch = is.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public static int readUnsignedByte(InputStream is) throws IOException {
        int ch = is.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public static double readDouble(InputStream is) throws IOException {
        return Double.longBitsToDouble(PDataStream.readLong(is));
    }

    public static float readFloat(InputStream is) throws IOException {
        return Float.intBitsToFloat(PDataStream.readInt(is));
    }

    public static String readString(InputStream is) throws IOException {
        if (PDataStream.readBoolean(is)) {
            return PDataStream.readUTF(is);
        }
        return null;
    }

    public static String readUTF(InputStream is) throws IOException {
        int utflen = PDataStream.readShort(is);
        char[] str = new char[utflen];
        int cnt = 0;
        int strlen = 0;
        while (cnt < utflen) {
            int c = PDataStream.readUnsignedByte(is);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++cnt;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((cnt += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = PDataStream.readUnsignedByte(is);
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((cnt += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = PDataStream.readUnsignedByte(is);
                    int char3 = PDataStream.readUnsignedByte(is);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(str, 0, strlen);
    }
}

