/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event.mapper;

import org.eclipse.equinox.internal.event.mapper.BundleEventAdapter;
import org.eclipse.equinox.internal.event.mapper.FrameworkEventAdapter;
import org.eclipse.equinox.internal.event.mapper.ServiceEventAdapter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class EventRedeliverer
implements FrameworkListener,
BundleListener,
ServiceListener {
    private final ServiceTracker<EventAdmin, EventAdmin> eventAdminTracker;
    private static final boolean DEBUG = false;
    private BundleContext bc;
    static /* synthetic */ Class class$0;

    public EventRedeliverer(BundleContext bc) {
        this.bc = bc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.event.EventAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventAdminTracker = new ServiceTracker(bc, clazz.getName(), null);
    }

    public void close() {
        this.eventAdminTracker.close();
        this.bc.removeFrameworkListener((FrameworkListener)this);
        this.bc.removeBundleListener((BundleListener)this);
        this.bc.removeServiceListener((ServiceListener)this);
    }

    public void open() {
        this.eventAdminTracker.open();
        this.bc.addFrameworkListener((FrameworkListener)this);
        this.bc.addBundleListener((BundleListener)this);
        this.bc.addServiceListener((ServiceListener)this);
    }

    private EventAdmin getEventAdmin() {
        return (EventAdmin)this.eventAdminTracker.getService();
    }

    public void frameworkEvent(FrameworkEvent event) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new FrameworkEventAdapter(event, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }

    private void printNoEventAdminError() {
    }

    public void bundleChanged(BundleEvent event) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new BundleEventAdapter(event, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }

    public void serviceChanged(ServiceEvent event) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            new ServiceEventAdapter(event, eventAdmin).redeliver();
        } else {
            this.printNoEventAdminError();
        }
    }
}

