/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.WarnStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compressor
extends ContextAwareBase {
    final CompressionMode compressionMode;

    public Compressor(CompressionMode compressionMode) {
        this.compressionMode = compressionMode;
    }

    public void compress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
        switch (this.compressionMode) {
            case GZ: {
                this.addInfo("GZ compressing [" + nameOfFile2Compress + "].");
                this.gzCompress(nameOfFile2Compress, nameOfCompressedFile);
                break;
            }
            case ZIP: {
                this.addInfo("ZIP compressing [" + nameOfFile2Compress + "].");
                this.zipCompress(nameOfFile2Compress, nameOfCompressedFile, innerEntryName);
                break;
            }
            case NONE: {
                throw new UnsupportedOperationException("compress method called in NONE compression mode");
            }
        }
    }

    private void zipCompress(String nameOfFile2zip, String nameOfZippedFile, String innerEntryName) {
        File zippedFile;
        File file2zip = new File(nameOfFile2zip);
        if (!file2zip.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2zip + "] does not exist.", this));
            return;
        }
        if (innerEntryName == null) {
            this.addStatus(new WarnStatus("The innerEntryName parameter cannot be null", this));
            return;
        }
        if (!nameOfZippedFile.endsWith(".zip")) {
            nameOfZippedFile = nameOfZippedFile + ".zip";
        }
        if ((zippedFile = new File(nameOfZippedFile)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + nameOfZippedFile + "] exist already.", this));
            return;
        }
        try {
            int n;
            FileOutputStream fos = new FileOutputStream(nameOfZippedFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            FileInputStream fis = new FileInputStream(nameOfFile2zip);
            ZipEntry zipEntry = this.computeZipEntry(innerEntryName);
            zos.putNextEntry(zipEntry);
            byte[] inbuf = new byte[8102];
            while ((n = fis.read(inbuf)) != -1) {
                zos.write(inbuf, 0, n);
            }
            fis.close();
            zos.close();
            if (!file2zip.delete()) {
                this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2zip + "].", this));
            }
        }
        catch (Exception e) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2zip + "] into [" + nameOfZippedFile + "].", this, e));
        }
    }

    ZipEntry computeZipEntry(File zippedFile) {
        return this.computeZipEntry(zippedFile.getName());
    }

    ZipEntry computeZipEntry(String filename) {
        String nameOfFileNestedWithinArchive = Compressor.computeFileNameStr_WCS(filename, this.compressionMode);
        return new ZipEntry(nameOfFileNestedWithinArchive);
    }

    private void gzCompress(String nameOfFile2gz, String nameOfgzedFile) {
        File gzedFile;
        File file2gz = new File(nameOfFile2gz);
        if (!file2gz.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2gz + "] does not exist.", this));
            return;
        }
        if (!nameOfgzedFile.endsWith(".gz")) {
            nameOfgzedFile = nameOfgzedFile + ".gz";
        }
        if ((gzedFile = new File(nameOfgzedFile)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + nameOfgzedFile + "] exist already.", this));
            return;
        }
        try {
            int n;
            FileOutputStream fos = new FileOutputStream(nameOfgzedFile);
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            FileInputStream fis = new FileInputStream(nameOfFile2gz);
            byte[] inbuf = new byte[8102];
            while ((n = fis.read(inbuf)) != -1) {
                gzos.write(inbuf, 0, n);
            }
            fis.close();
            gzos.close();
            if (!file2gz.delete()) {
                this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2gz + "].", this));
            }
        }
        catch (Exception e) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2gz + "] into [" + nameOfgzedFile + "].", this, e));
        }
    }

    public static String computeFileNameStr_WCS(String fileNamePatternStr, CompressionMode compressionMode) {
        int len = fileNamePatternStr.length();
        switch (compressionMode) {
            case GZ: {
                if (fileNamePatternStr.endsWith(".gz")) {
                    return fileNamePatternStr.substring(0, len - 3);
                }
                return fileNamePatternStr;
            }
            case ZIP: {
                if (fileNamePatternStr.endsWith(".zip")) {
                    return fileNamePatternStr.substring(0, len - 4);
                }
                return fileNamePatternStr;
            }
            case NONE: {
                return fileNamePatternStr;
            }
        }
        throw new IllegalStateException("Execution should not reach this point");
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.Compress";
    }
}

