/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

final class SystemBundleExportsResolver {
    static final String VERSION = "version";
    private static final String OSGI_RESOLVER_MODE = "osgi.resolverMode";
    private static final String OSGI_RESOLVER_MODE_STRICT = "strict";
    private static final String INTERNAL_DIRECTIVE = "x-internal";
    private static final String FRIENDS_DIRECTIVE = "x-friends";
    private final BundleContext bundleContext;

    SystemBundleExportsResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Map<String, VersionRange> getSystemBundleExports() {
        Bundle systemBundle = this.bundleContext.getBundle(0L);
        BundleWiring bundleWiring = ((BundleRevision)systemBundle.adapt(BundleRevision.class)).getWiring();
        List bundleCapabilities = bundleWiring.getCapabilities("osgi.wiring.package");
        boolean isStrictMode = OSGI_RESOLVER_MODE_STRICT.equals(this.bundleContext.getProperty(OSGI_RESOLVER_MODE));
        return SystemBundleExportsResolver.combineDuplicateExports(bundleCapabilities, isStrictMode);
    }

    static Map<String, VersionRange> combineDuplicateExports(List<BundleCapability> capabilities, boolean isStrictMode) {
        HashMap<String, VersionRange> exportedPackages = new HashMap<String, VersionRange>();
        for (BundleCapability exportedPackage : capabilities) {
            Map directives;
            if (isStrictMode && (Boolean.valueOf((String)(directives = exportedPackage.getDirectives()).get(INTERNAL_DIRECTIVE)).booleanValue() || directives.get(FRIENDS_DIRECTIVE) != null)) continue;
            String exportedPackageName = (String)exportedPackage.getAttributes().get("osgi.wiring.package");
            Version exportedPackageVersion = (Version)exportedPackage.getAttributes().get(VERSION);
            VersionRange versionRange = (VersionRange)exportedPackages.get(exportedPackageName);
            if (versionRange == null) {
                versionRange = VersionRange.createExactRange((Version)exportedPackageVersion);
            } else if (!versionRange.includes(exportedPackageVersion)) {
                versionRange = SystemBundleExportsResolver.expandVersionRange(exportedPackageVersion, versionRange);
            }
            exportedPackages.put(exportedPackageName, versionRange);
        }
        return exportedPackages;
    }

    private static VersionRange expandVersionRange(Version version, VersionRange versionRange) {
        Version ceiling = versionRange.getCeiling();
        if (version.compareTo(ceiling) > 0) {
            return new VersionRange("[" + versionRange.getFloor() + "," + version + "]");
        }
        return new VersionRange("[" + version + "," + versionRange.getCeiling() + "]");
    }
}

