/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.SequenceToRegex4SDF;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePatternToRegexUtil {
    final String datePattern;
    final int length;

    DatePatternToRegexUtil(String datePattern) {
        this.datePattern = datePattern;
        this.length = datePattern.length();
    }

    String toRegex() {
        List<SequenceToRegex4SDF> sequenceList = this.tokenize();
        StringBuilder sb = new StringBuilder();
        for (SequenceToRegex4SDF seq : sequenceList) {
            sb.append(seq.toRegex());
        }
        return sb.toString();
    }

    private List<SequenceToRegex4SDF> tokenize() {
        ArrayList<SequenceToRegex4SDF> sequenceList = new ArrayList<SequenceToRegex4SDF>();
        SequenceToRegex4SDF sequence = null;
        for (int i = 0; i < this.length; ++i) {
            char t = this.datePattern.charAt(i);
            if (sequence == null || sequence.c != t) {
                sequence = this.addNewSequence(sequenceList, t);
                continue;
            }
            sequence.inc();
        }
        return sequenceList;
    }

    SequenceToRegex4SDF addNewSequence(List<SequenceToRegex4SDF> sequenceList, char t) {
        SequenceToRegex4SDF token = new SequenceToRegex4SDF(t);
        sequenceList.add(token);
        return token;
    }
}

