/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateAccessor;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateInterceptor
extends HibernateAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction;
        Session session = this.getSession();
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
        boolean bl = existingTransaction = sessionHolder != null && sessionHolder.containsSession(session);
        if (existingTransaction) {
            this.logger.debug((Object)"Found thread-bound Session for HibernateInterceptor");
        } else if (sessionHolder != null) {
            sessionHolder.addSession(session);
        } else {
            TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)new SessionHolder(session)));
        }
        FlushMode previousFlushMode = null;
        try {
            previousFlushMode = this.applyFlushMode(session, existingTransaction);
            this.enableFilters(session);
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(session, existingTransaction);
            Object object = retVal;
            return object;
        }
        catch (HibernateException ex) {
            if (this.exceptionConversionEnabled) {
                throw this.convertHibernateAccessException(ex);
            }
            throw ex;
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after HibernateInterceptor");
                this.disableFilters(session);
                if (previousFlushMode != null) {
                    session.setFlushMode(previousFlushMode);
                }
            } else {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
                if (sessionHolder == null || sessionHolder.doesNotHoldNonDefaultSession()) {
                    TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
                }
            }
        }
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
    }
}

