/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.LocalClient;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.apache.openejb.core.ivm.ClientSecurity;
import org.apache.openejb.core.ivm.naming.ContextWrapper;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.ServiceManagerProxy;

public class LocalInitialContext
extends ContextWrapper {
    public static final String OPENEJB_EMBEDDED_REMOTABLE = "openejb.embedded.remotable";
    static Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, LocalInitialContext.class);
    private final LocalInitialContextFactory factory;
    private Properties properties = new Properties();
    private Object clientIdentity;
    public static final String ON_CLOSE = "openejb.embedded.initialcontext.close";
    private Close onClose;
    private Options options;
    private ServiceManagerProxy serviceManager;

    public LocalInitialContext(Hashtable env, LocalInitialContextFactory factory) throws NamingException {
        super(LocalInitialContext.getContainerSystemEjbContext());
        this.properties.putAll((Map<?, ?>)env);
        this.options = new Options(this.properties);
        this.onClose = (Close)this.options.get(ON_CLOSE, (Enum)Close.LOGOUT);
        this.factory = factory;
        this.login();
        this.startNetworkServices();
    }

    @Override
    public void close() throws NamingException {
        logger.debug("LocalIntialContext.close()");
        switch (this.onClose) {
            case LOGOUT: {
                this.logout();
                break;
            }
            case DESTROY: {
                this.logout();
                this.destroy();
            }
        }
    }

    private void destroy() throws NamingException {
        if (this.serviceManager != null) {
            this.serviceManager.stop();
        }
        this.tearDownOpenEJB();
    }

    private void tearDownOpenEJB() throws NamingException {
        if (this.factory.bootedOpenEJB()) {
            logger.info("Destroying container system");
            this.factory.close();
            this.context.close();
            OpenEJB.destroy();
        }
    }

    private void login() throws AuthenticationException {
        String user = (String)this.properties.get("java.naming.security.principal");
        String pass = (String)this.properties.get("java.naming.security.credentials");
        String realmName = (String)this.properties.get("openejb.authentication.realmName");
        if (user != null && pass != null) {
            try {
                logger.info("Logging in");
                SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
                this.clientIdentity = realmName == null ? securityService.login(user, pass) : securityService.login(realmName, user, pass);
                ClientSecurity.setIdentity(this.clientIdentity);
            }
            catch (LoginException e) {
                throw (AuthenticationException)new AuthenticationException("User could not be authenticated: " + user).initCause(e);
            }
        }
    }

    private void logout() {
        try {
            SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
            if (this.clientIdentity != null) {
                logger.info("Logging out");
                securityService.logout(this.clientIdentity);
                ClientSecurity.setIdentity(null);
            }
        }
        catch (LoginException e) {
            throw new RuntimeException("User could not be logged out.", e);
        }
    }

    private void startNetworkServices() {
        if (!this.options.get(OPENEJB_EMBEDDED_REMOTABLE, false)) {
            return;
        }
        try {
            this.serviceManager = new ServiceManagerProxy();
            this.serviceManager.start();
        }
        catch (ServiceManagerProxy.AlreadyStartedException e) {
            logger.debug("Network services already started.  Ignoring option openejb.embedded.remotable");
        }
    }

    private static Context getContainerSystemEjbContext() throws NamingException {
        Context context = LocalInitialContext.getRoot();
        context = (Context)context.lookup("openejb/local");
        return context;
    }

    private static Context getRoot() {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        Context context = containerSystem.getJNDIContext();
        return context;
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if ("inject".equalsIgnoreCase(name)) {
            this.inject(obj);
        } else {
            super.bind(name, obj);
        }
    }

    private void inject(Object obj) throws NamingException {
        if (obj == null) {
            throw new NullPointerException("Object supplied to 'inject' operation is null");
        }
        Context clients = (Context)LocalInitialContext.getRoot().lookup("openejb/client/");
        Context context = null;
        List injections = null;
        for (Class<?> clazz = obj.getClass(); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            try {
                String moduleId = (String)clients.lookup(clazz.getName());
                context = (Context)clients.lookup(moduleId);
                injections = (List)context.lookup("info/injections");
                break;
            }
            catch (NamingException e) {
                continue;
            }
        }
        if (injections == null) {
            throw new NamingException("Unable to find injection meta-data for " + obj.getClass().getName() + ".  Ensure that class was annotated with @" + LocalClient.class.getName() + " and was successfully discovered and deployed.  See http://openejb.apache.org/3.0/local-client-injection.html");
        }
        try {
            InjectionProcessor<Object> processor = new InjectionProcessor<Object>(obj, injections, context);
            processor.createInstance();
        }
        catch (OpenEJBException e) {
            throw (NamingException)new NamingException("Injection failed").initCause(e);
        }
    }

    public static enum Close {
        LOGOUT,
        DESTROY;

    }
}

