/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.services.accessor;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderJarScanner
implements JarScanner {
    private static final String JAR_URL_SUFFIX = "!/";
    private static final String JAR_URL_PREFIX = "jar:";
    private static final String REFERENCE_URL_PREFIX = "reference";
    public static final String SKIP_BUNDLES_PROPERTY = "gemini.web.scan.BundleDependenciesJarScanned.bundlesToSkip";
    private final Set<Bundle> bundles = new HashSet<Bundle>();
    private Logger logger = LoggerFactory.getLogger(ClassLoaderJarScanner.class);

    public ClassLoaderJarScanner(Set<Bundle> bundles) {
        this.bundles.addAll(bundles);
    }

    public void scan(ServletContext servletContext, ClassLoader classLoader, JarScannerCallback jarScannerCallback, Set<String> jarsToSkip) {
        for (Bundle bundle : this.bundles) {
            this.scanBundle(bundle, jarScannerCallback);
        }
    }

    private void scanBundle(Bundle bundle, JarScannerCallback callback) {
        File bundleFile = this.resolve(bundle);
        if (bundleFile != null) {
            this.scanBundleFile(bundleFile, callback);
        } else {
            this.scanJarUrlConnection(bundle, callback);
        }
    }

    private void scanJarUrlConnection(Bundle bundle, JarScannerCallback callback) {
        URL bundleUrl;
        String bundleLocation = bundle.getLocation();
        try {
            bundleUrl = new URL(bundleLocation);
            bundleUrl = REFERENCE_URL_PREFIX.equals(bundleUrl.getProtocol()) ? new URL(JAR_URL_PREFIX + bundleUrl.getFile() + JAR_URL_SUFFIX) : new URL(JAR_URL_PREFIX + bundleLocation + JAR_URL_SUFFIX);
        }
        catch (MalformedURLException e) {
            this.logger.warn("Failed to create jar: url for bundle location " + bundleLocation, (Throwable)e);
            return;
        }
        this.scanBundleUrl(bundleUrl, callback);
    }

    private void scanBundleFile(File bundleFile, JarScannerCallback callback) {
        if (bundleFile.isDirectory()) {
            try {
                callback.scan(bundleFile);
            }
            catch (IOException e) {
                this.logger.warn("Failure when attempting to scan bundle file '" + bundleFile + "':" + e.getMessage(), (Throwable)e);
            }
        } else {
            URL bundleUrl;
            try {
                bundleUrl = new URL(JAR_URL_PREFIX + bundleFile.toURI().toURL() + JAR_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                this.logger.warn("Failed to create jar: url for bundle file " + bundleFile, (Throwable)e);
                return;
            }
            this.scanBundleUrl(bundleUrl, callback);
        }
    }

    private void scanBundleUrl(URL url, JarScannerCallback callback) {
        try {
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection) {
                callback.scan((JarURLConnection)connection);
            }
        }
        catch (IOException e) {
            this.logger.warn("Failure when attempting to scan bundle via jar URL '" + url + "':" + e.getMessage(), (Throwable)e);
        }
    }

    private File resolve(Bundle bundle) {
        BundleFile bundleFile = this.getBundleFile(bundle);
        if (bundleFile != null) {
            File file = bundleFile.getBaseFile();
            this.logger.info("Resolved bundle '" + bundle.getSymbolicName() + "' to file '" + file.getAbsolutePath() + "'");
            return file;
        }
        return null;
    }

    private BundleFile getBundleFile(Bundle bundle) {
        BundleHost bh;
        BundleData bundleData;
        if (bundle instanceof BundleHost && (bundleData = (bh = (BundleHost)bundle).getBundleData()) instanceof BaseData) {
            return ((BaseData)bundleData).getBundleFile();
        }
        return null;
    }
}

