/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAdminDumpContributor
implements DumpContributor {
    private static final String PROPERTY_PATTERN = "%s:\t%s\n";
    private final Logger logger;
    private final ConfigurationAdmin configurationAdmin;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public ConfigurationAdminDumpContributor(ConfigurationAdmin configurationAdmin) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.configurationAdmin = configurationAdmin;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void contribute(Dump dump) throws DumpContributionFailedException {
        try {
            block12: {
                ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                try {
                    StringBuilder sb = new StringBuilder();
                    try {
                        Configuration[] configurationArray = this.configurationAdmin.listConfigurations(null);
                        int n = configurationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Configuration configuration = configurationArray[n2];
                            this.appendHeader(sb, configuration.getPid());
                            this.appendProperties(sb, configuration.getProperties());
                            this.appendFooter(sb);
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        this.logger.warn("Could not enumerate existing configurations");
                    }
                    FileWriter out = null;
                    try {
                        try {
                            out = dump.createFileWriter("configurationAdmin.properties");
                            out.write(sb.toString());
                        }
                        catch (IOException iOException) {
                            this.logger.warn("Could not write configurationAdmin dump");
                            IOUtils.closeQuietly((Closeable)out);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)out);
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
            }
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public String getName() {
        try {
            return "configurationAdmin";
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void appendHeader(StringBuilder sb, String pid) {
        try {
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                int i = 0;
                while (i < pid.length() + 4) {
                    sb.append("#");
                    ++i;
                }
                sb.append("\n# ").append(pid).append(" #\n");
                i = 0;
                while (i < pid.length() + 4) {
                    sb.append("#");
                    ++i;
                }
                sb.append("\n\n");
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void appendProperties(StringBuilder sb, Dictionary properties) {
        try {
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                Enumeration keys = properties.keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    this.appendProperty(sb, key, properties.get(key));
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private void appendProperty(StringBuilder sb, Object key, Object value) {
        try {
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                sb.append(String.format(PROPERTY_PATTERN, key, value));
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void appendFooter(StringBuilder sb) {
        try {
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            try {
                sb.append("\n\n");
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminDumpContributor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ConfigurationAdminDumpContributor.java", Class.forName("org.eclipse.virgo.nano.config.internal.ConfigurationAdminDumpContributor"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "contribute", "org.eclipse.virgo.nano.config.internal.ConfigurationAdminDumpContributor", "org.eclipse.virgo.medic.dump.Dump:", "dump:", "org.eclipse.virgo.medic.dump.DumpContributionFailedException:", "void"), 42);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "appendHeader", "org.eclipse.virgo.nano.config.internal.ConfigurationAdminDumpContributor", "java.lang.StringBuilder:java.lang.String:", "sb:pid:", "", "void"), 70);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "appendProperties", "org.eclipse.virgo.nano.config.internal.ConfigurationAdminDumpContributor", "java.lang.StringBuilder:java.util.Dictionary:", "sb:properties:", "", "void"), 81);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "appendProperty", "org.eclipse.virgo.nano.config.internal.ConfigurationAdminDumpContributor", "java.lang.StringBuilder:java.lang.Object:java.lang.Object:", "sb:key:value:", "", "void"), 89);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "appendFooter", "org.eclipse.virgo.nano.config.internal.ConfigurationAdminDumpContributor", "java.lang.StringBuilder:", "sb:", "", "void"), 93);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.config.internal.ConfigurationAdminDumpContributor");
    }
}

