/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cli;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.openejb.cli.Main;
import org.apache.openejb.cli.SystemExitException;
import org.apache.openejb.loader.SystemClassPath;

public class Bootstrap {
    private static final String OPENEJB_VERSION_PROPERTIES_FILE_NAME = "openejb-version.properties";
    private static final String OPENEJB_HOME_PROPERTY_NAME = "openejb.home";
    private static final String OPENEJB_BASE_PROPERTY_NAME = "openejb.base";
    private static final String OPENEJB_CLI_MAIN_CLASS_NAME = "org.apache.openejb.cli.MainImpl";

    private static void setupHome(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-Dopenejb.home")) {
                Bootstrap.addProperty(arg);
                continue;
            }
            if (!arg.startsWith("-Dopenejb.base")) continue;
            Bootstrap.addProperty(arg);
        }
        String homeProperty = System.getProperty(OPENEJB_HOME_PROPERTY_NAME);
        if (homeProperty != null && new File(homeProperty).exists()) {
            return;
        }
        try {
            URL classURL = Thread.currentThread().getContextClassLoader().getResource(OPENEJB_VERSION_PROPERTIES_FILE_NAME);
            if (classURL != null) {
                String propsString = classURL.getFile();
                URI uri = new URI(propsString = propsString.substring(0, propsString.indexOf("!")));
                File jarFile = new File(uri.getSchemeSpecificPart());
                if (jarFile.getName().indexOf("openejb-core") > -1) {
                    File lib = jarFile.getParentFile();
                    File home = lib.getParentFile().getCanonicalFile();
                    System.setProperty(OPENEJB_HOME_PROPERTY_NAME, home.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error setting openejb.home property: " + e.getClass() + ": " + e.getMessage());
        }
    }

    private static void addProperty(String arg) {
        String prop = arg.substring(arg.indexOf("-D") + 2, arg.indexOf("="));
        String val = arg.substring(arg.indexOf("=") + 1);
        System.setProperty(prop, val);
    }

    private static void setupClasspath() {
        try {
            File lib = new File(System.getProperty(OPENEJB_HOME_PROPERTY_NAME) + File.separator + "lib");
            SystemClassPath systemCP = new SystemClassPath();
            systemCP.addJarsToPath(lib);
        }
        catch (Exception e) {
            System.err.println("Error setting up the classpath: " + e.getClass() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        Bootstrap.setupHome(args);
        Bootstrap.setupClasspath();
        Class<?> clazz = Bootstrap.class.getClassLoader().loadClass(OPENEJB_CLI_MAIN_CLASS_NAME);
        Main main = (Main)clazz.newInstance();
        try {
            main.main(args);
        }
        catch (SystemExitException e) {
            System.exit(e.getExitCode());
        }
    }
}

