/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLContainerMapping;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLCompositeDirectCollectionMapping
extends AbstractCompositeDirectCollectionMapping
implements XMLMapping,
XMLContainerMapping,
XMLNillableMapping {
    private boolean isCDATA;
    private boolean isDefaultEmptyContainer = true;
    private boolean isWriteOnly;
    private AbstractNullPolicy nullPolicy = new NullPolicy();
    protected boolean reuseContainer;
    private boolean isCollapsingStringValues;
    private boolean isNormalizingStringValues;
    private AbstractNullPolicy wrapperNullPolicy;

    public XMLCompositeDirectCollectionMapping() {
        this.nullPolicy.setNullRepresentedByEmptyNode(true);
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        ContainerPolicy cp;
        super.initialize(session);
        if (this.getField() instanceof XMLField) {
            if (this.valueConverter instanceof TypeConversionConverter) {
                TypeConversionConverter converter = (TypeConversionConverter)this.valueConverter;
                this.getField().setType(converter.getObjectClass());
            }
            String xpathString = ((XMLField)this.getField()).getXPath();
            if (this.isAbstractCompositeDirectCollectionMapping() && xpathString.indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !xpathString.endsWith("text()")) {
                throw DescriptorException.invalidXpathForXMLDirectMapping(this);
            }
        }
        if ((cp = this.getContainerPolicy()) != null && cp.getContainerClass() == null) {
            Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(cp.getContainerClassName());
            cp.setContainerClass(cls);
        }
        ((XMLField)this.getField()).setIsCDATA(this.isCDATA());
    }

    public void setXPath(String xpathString) {
        if (xpathString.indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !xpathString.endsWith("text()")) {
            xpathString = String.valueOf(xpathString) + "/text()";
        }
        this.setField(new XMLField(xpathString));
    }

    public String getXPath() {
        return this.getFieldName();
    }

    @Override
    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        ContainerPolicy cp = this.getContainerPolicy();
        DOMRecord domRecord = (DOMRecord)row;
        Object fieldValue = domRecord.getValues(this.getField(), this.getNullPolicy());
        if (fieldValue == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
                return container != null ? container : cp.containerInstance();
            }
            return cp.containerInstance();
        }
        Vector fieldValues = this.getDescriptor().buildDirectValuesFromFieldValue(fieldValue);
        if (fieldValues == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
                return container != null ? container : cp.containerInstance();
            }
            return cp.containerInstance();
        }
        Object result = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
            result = container != null ? container : cp.containerInstance();
        } else {
            result = cp.containerInstance(fieldValues.size());
        }
        Enumeration stream = fieldValues.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            if (this.valueConverter != null) {
                element = this.valueConverter instanceof XMLConverter ? ((XMLConverter)this.valueConverter).convertDataValueToObjectValue(element, executionSession, ((XMLRecord)row).getUnmarshaller()) : this.valueConverter.convertDataValueToObjectValue(element, executionSession);
            }
            if (element != null && element.getClass() == ClassConstants.STRING) {
                if (this.isCollapsingStringValues) {
                    element = XMLConversionManager.getDefaultXMLManager().collapseStringValue((String)element);
                } else if (this.isNormalizingStringValues) {
                    element = XMLConversionManager.getDefaultXMLManager().normalizeStringValue((String)element);
                }
            }
            cp.addInto(element, result, sourceQuery.getSession());
        }
        return result;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        if (iter != null) {
            while (cp.hasNext(iter)) {
                Object element = cp.next(iter, session);
                if (this.valueConverter != null) {
                    element = this.valueConverter instanceof XMLConverter ? ((XMLConverter)this.valueConverter).convertObjectValueToDataValue(element, session, ((XMLRecord)row).getMarshaller()) : this.valueConverter.convertObjectValueToDataValue(element, session);
                }
                if (element != null) {
                    elements.addElement(element);
                    continue;
                }
                if (this.usesSingleNode()) continue;
                AbstractNullPolicy nullPolicy = this.getNullPolicy();
                if (nullPolicy == null) {
                    elements.addElement(null);
                    continue;
                }
                if (nullPolicy.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                    elements.addElement(XMLRecord.NIL);
                    continue;
                }
                if (nullPolicy.getMarshalNullRepresentation() == XMLNullRepresentationType.ABSENT_NODE) continue;
                elements.addElement("");
            }
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = this.getDescriptor().buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        row.put(this.getField(), fieldValue);
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        Object element = value;
        if (this.valueConverter != null) {
            element = this.valueConverter instanceof XMLConverter ? ((XMLConverter)this.valueConverter).convertObjectValueToDataValue(element, session, record.getMarshaller()) : this.valueConverter.convertObjectValueToDataValue(element, session);
        }
        record.add(this.getField(), element);
    }

    public void setIsCDATA(boolean CDATA) {
        this.isCDATA = CDATA;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    @Override
    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    @Override
    public void setNullPolicy(AbstractNullPolicy value) {
        this.nullPolicy = value;
    }

    @Override
    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    @Override
    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    public boolean isNormalizingStringValues() {
        return this.isNormalizingStringValues;
    }

    public void setNormalizingStringValues(boolean normalize) {
        this.isNormalizingStringValues = normalize;
    }

    public void setCollapsingStringValues(boolean collapse) {
        this.isCollapsingStringValues = collapse;
    }

    public boolean isCollapsingStringValues() {
        return this.isCollapsingStringValues;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.isDefaultEmptyContainer;
    }

    @Override
    public void setDefaultEmptyContainer(boolean defaultEmptyContainer) {
        this.isDefaultEmptyContainer = defaultEmptyContainer;
    }

    @Override
    public AbstractNullPolicy getWrapperNullPolicy() {
        return this.wrapperNullPolicy;
    }

    @Override
    public void setWrapperNullPolicy(AbstractNullPolicy policy) {
        this.wrapperNullPolicy = policy;
    }
}

