/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitConfigHandler
implements ConfigAnnotationHandler {
    private static final Collection<Class<? extends Annotation>> HANDLES;
    Map<Class<?>, Annotation> annotatedRenderers;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        if (this.annotatedRenderers == null) {
            this.annotatedRenderers = new HashMap();
        }
        this.annotatedRenderers.put(target, annotation);
    }

    @Override
    public void push(FacesContext ctx) {
        if (this.annotatedRenderers != null) {
            RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            for (Map.Entry<Class<?>, Annotation> entry : this.annotatedRenderers.entrySet()) {
                RenderKit rk;
                Class<?> rClass = entry.getKey();
                if (entry.getValue() instanceof FacesRenderer) {
                    FacesRenderer ra = (FacesRenderer)entry.getValue();
                    try {
                        rk = rkf.getRenderKit(ctx, ra.renderKitId());
                        if (rk == null) {
                            throw new IllegalStateException("Error processing annotated Renderer " + ra.toString() + " on class " + rClass.getName() + ".  Unable to find specified RenderKit.");
                        }
                        rk.addRenderer(ra.componentFamily(), ra.rendererType(), (Renderer)rClass.newInstance());
                        continue;
                    }
                    catch (Exception e) {
                        throw new FacesException((Throwable)e);
                    }
                }
                if (!(entry.getValue() instanceof FacesBehaviorRenderer)) continue;
                FacesBehaviorRenderer bra = (FacesBehaviorRenderer)entry.getValue();
                try {
                    rk = rkf.getRenderKit(ctx, bra.renderKitId());
                    if (rk == null) {
                        throw new IllegalStateException("Error processing annotated ClientBehaviorRenderer " + bra.toString() + " on class " + rClass.getName() + ".  Unable to find specified RenderKit.");
                    }
                    rk.addClientBehaviorRenderer(bra.rendererType(), (ClientBehaviorRenderer)rClass.newInstance());
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
    }

    static {
        ArrayList<Class> handles = new ArrayList<Class>(2);
        handles.add(FacesRenderer.class);
        handles.add(FacesBehaviorRenderer.class);
        HANDLES = Collections.unmodifiableCollection(handles);
    }
}

