/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.FetchAttributeMetadata;
import org.eclipse.persistence.queries.FetchGroup;

public class FetchGroupMetadata
extends ORMetadata {
    private List<FetchAttributeMetadata> m_fetchAttributes = new ArrayList<FetchAttributeMetadata>();
    private String m_name;
    private Boolean m_load;

    public FetchGroupMetadata() {
        super("<fetch-group>");
        this.m_load = Boolean.FALSE;
    }

    public FetchGroupMetadata(MetadataAnnotation fetchGroup, MetadataAccessor accessor) {
        super(fetchGroup, accessor);
        this.m_name = (String)fetchGroup.getAttribute("name");
        this.m_load = (Boolean)fetchGroup.getAttributeBooleanDefaultFalse("load");
        Object[] objectArray = (Object[])fetchGroup.getAttributeArray("attributes");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object fetchAttribute = objectArray[n2];
            this.m_fetchAttributes.add(new FetchAttributeMetadata((MetadataAnnotation)fetchAttribute, accessor));
            ++n2;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof FetchGroupMetadata) {
            FetchGroupMetadata fetchGroup = (FetchGroupMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, fetchGroup.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_load, fetchGroup.getLoad())) {
                return false;
            }
            return this.valuesMatch(this.m_fetchAttributes, fetchGroup.getFetchAttributes());
        }
        return false;
    }

    public List<FetchAttributeMetadata> getFetchAttributes() {
        return this.m_fetchAttributes;
    }

    public Boolean getLoad() {
        return this.m_load;
    }

    public String getName() {
        return this.m_name;
    }

    public void process(ClassAccessor accessor) {
        FetchGroupManager fetchGroupManager;
        MetadataDescriptor descriptor = accessor.getDescriptor();
        if (descriptor.getClassDescriptor().hasFetchGroupManager()) {
            fetchGroupManager = descriptor.getClassDescriptor().getFetchGroupManager();
        } else {
            fetchGroupManager = new FetchGroupManager();
            descriptor.getClassDescriptor().setFetchGroupManager(fetchGroupManager);
        }
        if (fetchGroupManager.hasFetchGroup(this.m_name)) {
            this.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_fetch_group", descriptor.getJavaClass(), (Object)accessor.getJavaClass(), (Object)this.m_name);
        } else {
            FetchGroup fetchGroup = new FetchGroup();
            fetchGroup.setName(this.m_name);
            for (FetchAttributeMetadata fetchAttribute : this.m_fetchAttributes) {
                fetchGroup.addAttribute(fetchAttribute.getName());
            }
            fetchGroupManager.addFetchGroup(fetchGroup);
        }
    }

    public void setFetchAttributes(List<FetchAttributeMetadata> attributes) {
        this.m_fetchAttributes = attributes;
    }

    public void setLoad(Boolean load) {
        this.m_load = load;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

