/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.jsr303.ApacheFactoryContext;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.BeanDescriptorImpl;
import org.apache.bval.jsr303.ConstraintValidationListener;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.GroupValidationContextImpl;
import org.apache.bval.jsr303.NestedMetaProperty;
import org.apache.bval.jsr303.UnknownPropertyException;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.groups.Groups;
import org.apache.bval.jsr303.groups.GroupsComputer;
import org.apache.bval.jsr303.util.ClassHelper;
import org.apache.bval.jsr303.util.NodeImpl;
import org.apache.bval.jsr303.util.PathImpl;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.ValidationHelper;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassValidator
implements Validator {
    protected final ApacheFactoryContext factoryContext;
    protected final GroupsComputer groupsComputer = new GroupsComputer();
    private boolean treatMapsLikeBeans = false;

    public ClassValidator(ApacheFactoryContext factoryContext) {
        this.factoryContext = factoryContext;
    }

    public ClassValidator(ApacheValidatorFactory factory) {
        this(factory.usingContext());
    }

    public MetaBeanFinder getMetaBeanFinder() {
        return this.factoryContext.getMetaBeanFinder();
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("cannot validate null");
        }
        this.checkGroups(groups);
        try {
            Class<?> objectClass = object.getClass();
            MetaBean objectMetaBean = this.factoryContext.getMetaBeanFinder().findForClass(objectClass);
            GroupValidationContext<T> context = this.createContext(objectMetaBean, object, objectClass, groups);
            ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
            Groups sequence = context.getGroups();
            for (Group group : sequence.getGroups()) {
                context.setCurrentGroup(group);
                this.validateBeanNet(context);
            }
            for (List list : sequence.getSequences()) {
                for (Group current : list) {
                    context.setCurrentGroup(current);
                    this.validateBeanNet(context);
                    if (result.isEmpty()) continue;
                    break;
                }
                if (result.isEmpty()) continue;
                break;
            }
            return result.getConstraintViolations();
        }
        catch (RuntimeException ex) {
            throw ClassValidator.unrecoverableValidationError(ex, object);
        }
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("cannot validate null");
        }
        this.checkPropertyName(propertyName);
        this.checkGroups(groups);
        try {
            Class<?> objectClass = object.getClass();
            MetaBean objectMetaBean = this.factoryContext.getMetaBeanFinder().findForClass(objectClass);
            GroupValidationContext<T> context = this.createContext(objectMetaBean, object, objectClass, groups);
            ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
            NestedMetaProperty nestedProp = this.getNestedProperty(objectMetaBean, object, propertyName);
            context.setMetaProperty(nestedProp.getMetaProperty());
            if (nestedProp.isNested()) {
                context.setFixedValue(nestedProp.getValue());
            }
            if (context.getMetaProperty() == null) {
                throw new IllegalArgumentException("Unknown property " + object.getClass().getName() + "." + propertyName);
            }
            Groups sequence = context.getGroups();
            for (Group group : sequence.getGroups()) {
                context.setCurrentGroup(group);
                this.validatePropertyInGroup(context);
            }
            for (List list : sequence.getSequences()) {
                for (Group current : list) {
                    context.setCurrentGroup(current);
                    this.validatePropertyInGroup(context);
                    if (result.isEmpty()) continue;
                    break;
                }
                if (result.isEmpty()) continue;
                break;
            }
            return result.getConstraintViolations();
        }
        catch (RuntimeException ex) {
            throw ClassValidator.unrecoverableValidationError(ex, object);
        }
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        this.checkBeanType(beanType);
        this.checkPropertyName(propertyName);
        this.checkGroups(groups);
        try {
            MetaBean metaBean = this.factoryContext.getMetaBeanFinder().findForClass(beanType);
            GroupValidationContext<Object> context = this.createContext(metaBean, null, beanType, groups);
            ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
            context.setMetaProperty(this.getNestedProperty(metaBean, null, propertyName).getMetaProperty());
            context.setFixedValue(value);
            Groups sequence = context.getGroups();
            for (Group group : sequence.getGroups()) {
                context.setCurrentGroup(group);
                this.validatePropertyInGroup(context);
            }
            for (List list : sequence.getSequences()) {
                for (Group current : list) {
                    context.setCurrentGroup(current);
                    this.validatePropertyInGroup(context);
                    if (result.isEmpty()) continue;
                    break;
                }
                if (result.isEmpty()) continue;
                break;
            }
            return result.getConstraintViolations();
        }
        catch (RuntimeException ex) {
            throw ClassValidator.unrecoverableValidationError(ex, value);
        }
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        try {
            MetaBean metaBean = this.factoryContext.getMetaBeanFinder().findForClass(clazz);
            BeanDescriptorImpl edesc = (BeanDescriptorImpl)metaBean.getFeature("BeanDescriptor");
            if (edesc == null) {
                edesc = this.createBeanDescriptor(metaBean);
                metaBean.putFeature("BeanDescriptor", edesc);
            }
            return edesc;
        }
        catch (RuntimeException ex) {
            throw new ValidationException("error retrieving constraints for " + clazz, (Throwable)ex);
        }
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            ClassValidator result = this;
            return (T)result;
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            return SecureActions.newInstance(type, new Class[]{ApacheFactoryContext.class}, new Object[]{this.factoryContext});
        }
        try {
            Class cls = ClassUtils.getClass((String)(type.getName() + "Impl"));
            if (type.isAssignableFrom(cls)) {
                Class implClass = cls;
                return SecureActions.newInstance(implClass, new Class[]{ApacheFactoryContext.class}, new Object[]{this.factoryContext});
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    protected void validateBeanNet(GroupValidationContext<?> context) {
        if (context.getBean() == null) {
            return;
        }
        if (!context.collectValidated()) {
            return;
        }
        if (context.getCurrentGroup().isDefault()) {
            List<Group> defaultGroups = this.expandDefaultGroup(context);
            ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
            if (defaultGroups.size() > 1) {
                int numViolations = result.violationsSize();
                Group currentGroup = context.getCurrentGroup();
                for (Group group : defaultGroups) {
                    context.setCurrentGroup(group);
                    ValidationHelper.validateBean(context);
                    if (result.violationsSize() <= numViolations) continue;
                    break;
                }
                context.setCurrentGroup(currentGroup);
            } else {
                ArrayList classHierarchy = new ArrayList();
                ClassHelper.fillFullClassHierarchyAsList(classHierarchy, context.getMetaBean().getBeanClass());
                Class<?> initialOwner = context.getCurrentOwner();
                block1: for (Class clazz : classHierarchy) {
                    context.setCurrentOwner(clazz);
                    int numViolations = result.violationsSize();
                    List ownerDefaultGroups = (List)context.getMetaBean().getFeature("{GroupSequence:" + clazz.getCanonicalName() + "}");
                    for (Group each : ownerDefaultGroups) {
                        context.setCurrentGroup(each);
                        ValidationHelper.validateBean(context);
                        if (result.violationsSize() <= numViolations) continue;
                        continue block1;
                    }
                }
                context.setCurrentOwner(initialOwner);
                context.setCurrentGroup(Group.DEFAULT);
            }
        } else {
            ValidationHelper.validateBean(context);
        }
        for (MetaProperty prop : context.getMetaBean().getProperties()) {
            this.validateCascadedBean(context, prop);
        }
    }

    private void validateCascadedBean(GroupValidationContext<?> context, MetaProperty prop) {
        AccessStrategy[] access = (AccessStrategy[])prop.getFeature("refCascade");
        if (access != null) {
            Object bean = context.getBean();
            MetaBean mbean = context.getMetaBean();
            for (AccessStrategy each : access) {
                if (!this.isCascadable(context, prop, each)) continue;
                context.moveDown(prop, each);
                ValidationHelper.validateContext(context, new Jsr303ValidationCallback(context), this.treatMapsLikeBeans);
                context.moveUp(bean, mbean);
            }
        }
    }

    private boolean isCascadable(GroupValidationContext<?> context, MetaProperty prop, AccessStrategy access) {
        PathImpl beanPath = context.getPropertyPath();
        NodeImpl node = new NodeImpl(prop.getName());
        if (beanPath == null) {
            beanPath = PathImpl.create(null);
        }
        try {
            if (!context.getTraversableResolver().isReachable(context.getBean(), (Path.Node)node, context.getRootMetaBean().getBeanClass(), (Path)beanPath, access.getElementType())) {
                return false;
            }
        }
        catch (RuntimeException e) {
            throw new ValidationException("Error in TraversableResolver.isReachable() for " + context.getBean(), (Throwable)e);
        }
        try {
            if (!context.getTraversableResolver().isCascadable(context.getBean(), (Path.Node)node, context.getRootMetaBean().getBeanClass(), (Path)beanPath, access.getElementType())) {
                return false;
            }
        }
        catch (RuntimeException e) {
            throw new ValidationException("Error TraversableResolver.isCascadable() for " + context.getBean(), (Throwable)e);
        }
        return true;
    }

    private List<Group> expandDefaultGroup(GroupValidationContext<?> context) {
        if (context.getCurrentGroup().isDefault()) {
            List groupSeq = (List)context.getMetaBean().getFeature("GroupSequence");
            if (groupSeq != null) {
                context.getGroups().assertDefaultGroupSequenceIsExpandable(groupSeq);
            }
            return groupSeq;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RuntimeException unrecoverableValidationError(RuntimeException ex, Object object) {
        if (ex instanceof UnknownPropertyException) {
            return new IllegalArgumentException(ex.getMessage(), ex);
        }
        if (ex instanceof ValidationException) {
            return ex;
        }
        String objectId = "";
        try {
            if (object != null) {
                objectId = object.toString();
            }
            objectId = "<null>";
            return objectId;
        }
        catch (Exception e) {
            objectId = "<unknown>";
            return objectId;
        }
        finally {
            return new ValidationException("error during validation of " + objectId, (Throwable)ex);
        }
    }

    private void validatePropertyInGroup(GroupValidationContext<?> context) {
        Group currentGroup = context.getCurrentGroup();
        List<Group> defaultGroups = this.expandDefaultGroup(context);
        if (defaultGroups != null) {
            for (Group each : defaultGroups) {
                context.setCurrentGroup(each);
                ValidationHelper.validateProperty(context);
            }
            context.setCurrentGroup(currentGroup);
        } else {
            ValidationHelper.validateProperty(context);
        }
    }

    private NestedMetaProperty getNestedProperty(MetaBean metaBean, Object t, String propertyName) {
        NestedMetaProperty nested = new NestedMetaProperty(propertyName, t);
        nested.setMetaBean(metaBean);
        nested.parse();
        return nested;
    }

    protected <T> GroupValidationContext<T> createContext(MetaBean metaBean, T object, Class<T> objectClass, Class<?>[] groups) {
        ConstraintValidationListener<T> listener = new ConstraintValidationListener<T>(object, objectClass);
        GroupValidationContextImpl<T> context = new GroupValidationContextImpl<T>(listener, this.factoryContext.getMessageInterpolator(), this.factoryContext.getTraversableResolver(), metaBean);
        context.setBean(object, metaBean);
        context.setGroups(this.groupsComputer.computeGroups(groups));
        return context;
    }

    protected BeanDescriptorImpl createBeanDescriptor(MetaBean metaBean) {
        return new BeanDescriptorImpl(this.factoryContext, metaBean);
    }

    public boolean isTreatMapsLikeBeans() {
        return this.treatMapsLikeBeans;
    }

    public void setTreatMapsLikeBeans(boolean treatMapsLikeBeans) {
        this.treatMapsLikeBeans = treatMapsLikeBeans;
    }

    private void checkBeanType(Class<?> beanType) {
        if (beanType == null) {
            throw new IllegalArgumentException("Bean type cannot be null.");
        }
    }

    private void checkPropertyName(String propertyName) {
        if (propertyName == null || propertyName.trim().length() == 0) {
            throw new IllegalArgumentException("Property path cannot be null or empty.");
        }
    }

    private void checkGroups(Class<?>[] groups) {
        if (groups == null) {
            throw new IllegalArgumentException("Groups cannot be null.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Jsr303ValidationCallback
    implements ValidationHelper.ValidateCallback {
        private final GroupValidationContext<?> context;

        public Jsr303ValidationCallback(GroupValidationContext<?> context) {
            this.context = context;
        }

        @Override
        public void validate() {
            ClassValidator.this.validateBeanNet(this.context);
        }
    }
}

